/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.util.Collection;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.util.CollectionGenerator;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

public class CollectionNodeHandler
implements NodeHandler {
    private final ModelContext<?> context;
    private final GeneratorSpecProcessor beanValidationProcessors;

    public CollectionNodeHandler(ModelContext<?> context, GeneratorSpecProcessor beanValidationProcessors) {
        this.context = context;
        this.beanValidationProcessors = beanValidationProcessors;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        if (Collection.class.isAssignableFrom(node.getTargetClass())) {
            CollectionGenerator generator = new CollectionGenerator(new GeneratorContext(this.context.getSettings(), this.context.getRandom()));
            generator.subtype((Class)node.getTargetClass());
            this.beanValidationProcessors.process(generator, node.getTargetClass(), node.getField());
            return GeneratorResult.create(generator.generate(this.context.getRandom()), generator.hints());
        }
        return GeneratorResult.emptyResult();
    }
}

