/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.instancio.Model;
import org.instancio.TypeTokenSupplier;
import org.instancio.exception.InstancioApiException;
import org.instancio.generator.Generator;
import org.instancio.internal.ApiValidatorMessageHelper;
import org.instancio.internal.GeneratorSupport;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.SettingKey;
import org.jetbrains.annotations.Nullable;

public final class ApiValidator {
    private static final String CREATE_TYPE_TOKEN_HELP = "%n\tExample:%n\tMap<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});%n%n\t// or the builder version%n\tMap<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){}).create();";
    private static final String CREATE_CLASS_HELP = "%n\tExample:%n\tPerson person = Instancio.create(Person.class);%n%n\t// or the builder version%n\tPerson person = Instancio.of(Person.class).create();";

    public static <T> Class<T> validateRootClass(@Nullable Class<T> klass) {
        ApiValidator.isTrue(klass != null, "class must not be null%n -> Please provide a valid class%n%n\tExample:%n\tPerson person = Instancio.create(Person.class);%n%n\t// or the builder version%n\tPerson person = Instancio.of(Person.class).create();", new Object[0]);
        return klass;
    }

    public static Type validateTypeToken(@Nullable TypeTokenSupplier<?> typeTokenSupplier) {
        ApiValidator.isTrue(typeTokenSupplier != null, "type token must not be null%n -> Please provide a valid type token%n%n\tExample:%n\tMap<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});%n%n\t// or the builder version%n\tMap<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){}).create();", new Object[0]);
        Type type = typeTokenSupplier.get();
        ApiValidator.isTrue(type != null, "type token must not return a null Type%n -> Please provide a valid Type%n%n\tExample:%n\tMap<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});%n%n\t// or the builder version%n\tMap<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){}).create();", new Object[0]);
        return type;
    }

    public static void validateTypeParameters(Class<?> rootClass, List<Class<?>> rootTypeParameters) {
        int typeVarsLength;
        int n = typeVarsLength = rootClass.isArray() ? rootClass.getComponentType().getTypeParameters().length : rootClass.getTypeParameters().length;
        if (typeVarsLength == 0 && !rootTypeParameters.isEmpty()) {
            throw Fail.withUsageError(ApiValidatorMessageHelper.withTypeParametersNonGenericClass(rootClass), new Object[0]);
        }
        ApiValidator.isTrue(typeVarsLength == rootTypeParameters.size(), ApiValidatorMessageHelper.withTypeParametersNumberOfParameters(rootClass, rootTypeParameters), new Object[0]);
        for (Class<?> param : rootTypeParameters) {
            if (param.getTypeParameters().length <= 0) continue;
            String classWithTypeParams = String.format("%s<%s>", param.getSimpleName(), Format.getTypeVariablesCsv(param));
            throw Fail.withUsageError(ApiValidatorMessageHelper.withTypeParametersNestedGenerics(classWithTypeParams), new Object[0]);
        }
    }

    public static void validateSubtype(Class<?> from, Class<?> to) {
        ApiValidator.isTrue(from.isAssignableFrom(to), () -> String.format("invalid subtype mapping%n -> class '%s' is not a subtype of '%s'", to.getTypeName(), from.getTypeName()));
    }

    public static void validateKeyValue(@Nullable SettingKey<?> key, @Nullable Object value) {
        ApiValidator.isTrue(key != null, "setting key must not be null", new Object[0]);
        if (!key.allowsNullValue()) {
            ApiValidator.isTrue(value != null, "setting value for key '%s' must not be null", key.propertyKey());
        }
    }

    public static <T> T[] notEmpty(@Nullable T[] array, String message, Object ... values) {
        ApiValidator.isTrue(array != null && array.length > 0, message, values);
        return array;
    }

    public static <T> Collection<T> notEmpty(@Nullable Collection<T> collection, String message, Object ... values) {
        ApiValidator.isTrue(collection != null && !collection.isEmpty(), message, values);
        return collection;
    }

    public static void validateGeneratorUsage(InternalNode node, Generator<?> generator) {
        AbstractGenerator<?> absGen = GeneratorSupport.unpackGenerator(generator);
        if (absGen == null) {
            return;
        }
        String name = absGen.apiMethod();
        if (name != null) {
            ApiValidator.isTrue(GeneratorSupport.supports(absGen, node.getTargetClass()), () -> String.format(ApiValidator.generateMismatchErrorMessageTemplate(node, name), new Object[0]));
        }
    }

    private static String generateMismatchErrorMessageTemplate(InternalNode node, String apiMethodName) {
        return "the target type is incompatible with the generator%n -> Method '" + apiMethodName + "' cannot be used for type: " + node.getTargetClass().getCanonicalName() + (node.getField() == null ? "" : "%n -> Field: " + node.getField());
    }

    public static void validateGenerateSecondArgument(Object arg) {
        ApiValidator.isFalse(arg == null, () -> String.format("the second argument of 'generate()' method must not be null%n -> To generate a null value, use 'set(TargetSelector, null)'%n%n\tExample:%n\tPerson person = Instancio.of(Person.class)%n\t\t.set(field(\"firstName\"), null)%n\t\t.create();", new Object[0]));
    }

    public static void validateGeneratorNotNull(@Nullable Object obj) {
        ApiValidator.validateSupplierOrGenerator(obj, "Generator");
    }

    public static void validateSupplierNotNull(@Nullable Object obj) {
        ApiValidator.validateSupplierOrGenerator(obj, "Supplier");
    }

    private static void validateSupplierOrGenerator(@Nullable Object obj, String supplierOrGenerator) {
        ApiValidator.isFalse(obj == null, () -> String.format("null %s passed to 'supply()' method%n -> To generate a null value, use 'set(TargetSelector, null)'%n%n\tExample:%n\tPerson person = Instancio.of(Person.class)%n\t\t.set(field(\"firstName\"), null)%n\t\t.create();", supplierOrGenerator));
    }

    public static <E> Model<E> valueSpecDoesNotSupportToModel(String specMethodName) {
        throw new InstancioApiException(specMethodName + " spec does not support toModel()");
    }

    public static int validateSize(int size) {
        ApiValidator.isTrue(size >= 0, "size must not be negative: %s", size);
        return size;
    }

    public static int validateLength(int length) {
        ApiValidator.isTrue(length >= 0, "length must not be negative: %s", length);
        return length;
    }

    public static <T extends Comparable<T>> void validateStartEnd(T min, T max) {
        ApiValidator.isTrue(min.compareTo(max) <= 0, "start must not exceed end: %s, %s", min, max);
    }

    public static <T> T notNull(@Nullable T obj, String message, Object ... values) {
        if (obj == null) {
            throw Fail.withUsageError(String.format(message, values), new Object[0]);
        }
        return obj;
    }

    public static <T> T notNull(@Nullable T obj, Supplier<String> supplier) {
        if (obj == null) {
            throw Fail.withUsageError(supplier.get(), new Object[0]);
        }
        return obj;
    }

    public static void isTrue(boolean condition, String message, Object ... values) {
        if (!condition) {
            throw Fail.withUsageError(String.format(message, values), new Object[0]);
        }
    }

    public static void isFalse(boolean condition, String message, Object ... values) {
        if (condition) {
            throw Fail.withUsageError(String.format(message, values), new Object[0]);
        }
    }

    private static void isTrue(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw Fail.withUsageError(message.get(), new Object[0]);
        }
    }

    public static void isFalse(boolean condition, Supplier<String> message) {
        if (condition) {
            throw Fail.withUsageError(message.get(), new Object[0]);
        }
    }

    public static int validateDepth(int depth) {
        if (depth < 0) {
            throw Fail.withUsageError("depth must not be negative: " + depth, new Object[0]);
        }
        return depth;
    }

    public static void validateField(Class<?> declaringClass, String fieldName, String message) {
        ApiValidator.notNull(declaringClass, message, new Object[0]);
        ApiValidator.notNull(fieldName, message, new Object[0]);
        ApiValidator.isTrue(ReflectionUtils.isValidField(declaringClass, fieldName), message, new Object[0]);
    }

    private ApiValidator() {
    }
}

