/*
 * Decompiled with CFR 0.152.
 */
package com.insac.can.livebus.core;

import com.insac.can.livebus.core.LiveEvent;
import com.insac.can.livebus.core.LiveEventBase;
import com.insac.can.livebus.core.SingleLiveEvent;
import com.insac.can.livebus.core.StickyLiveEvent;
import com.insac.can.livebus.core.StickySingleLiveEvent;
import com.insac.can.livebus.utils.LiveBusException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ!\u0010\n\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ!\u0010\u000b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ!\u0010\f\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010J\u0014\u0010\u0011\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0012\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0015J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0015J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0015J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0015\u00a8\u0006\u001a"}, d2={"Lcom/insac/can/livebus/core/LiveBus;", "", "()V", "postLiveEvent", "", "T", "tag", "", "eventValue", "(Ljava/lang/String;Ljava/lang/Object;)V", "postSingleEvent", "postStickyEvent", "postStickySingleEvent", "removeEvent", "", "liveEvent", "Lcom/insac/can/livebus/core/LiveEventBase;", "removeStickyEvent", "subscribeEvent", "subscribeLiveEvent", "type", "Ljava/lang/Class;", "subscribeSingleLiveEvent", "subscribeStickyLiveEvent", "subscribeStickySingleLiveEvent", "Companion", "livebus_release"})
public final class LiveBus {
    private static LiveBus mInstance;
    private static HashMap<String, LiveEventBase<? extends Object>> mEvents;
    public static final Companion Companion;

    public final <T> boolean removeEvent(@NotNull LiveEventBase<T> liveEvent) {
        Intrinsics.checkParameterIsNotNull(liveEvent, (String)"liveEvent");
        if (!mEvents.containsValue(liveEvent)) {
            return false;
        }
        for (Map.Entry<String, LiveEventBase<? extends Object>> entry : mEvents.entrySet()) {
            if (Intrinsics.areEqual(entry.getValue(), liveEvent) ^ true) continue;
            mEvents.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public final <T> void postLiveEvent(@NotNull String tag, T eventValue) {
        block1: {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Map map2 = map = (Map)mEvents;
            if (!map2.containsKey(tag)) {
                LiveEvent liveEvent = new LiveEvent();
                map2 = mEvents;
                LiveEvent liveEvent2 = liveEvent;
                map2.put(tag, liveEvent2);
            }
            LiveEventBase<? extends Object> liveEventBase = mEvents.get(tag);
            if (liveEventBase == null) break block1;
            liveEventBase.setValue(eventValue);
        }
    }

    public final <T> void postSingleEvent(@NotNull String tag, T eventValue) {
        block1: {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Map map2 = map = (Map)mEvents;
            if (!map2.containsKey(tag)) {
                SingleLiveEvent liveEvent = new SingleLiveEvent();
                map2 = mEvents;
                SingleLiveEvent singleLiveEvent = liveEvent;
                map2.put(tag, singleLiveEvent);
            }
            LiveEventBase<? extends Object> liveEventBase = mEvents.get(tag);
            if (liveEventBase == null) break block1;
            liveEventBase.setValue(eventValue);
        }
    }

    public final <T> void postStickySingleEvent(@NotNull String tag, T eventValue) {
        block1: {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Map map2 = map = (Map)mEvents;
            if (!map2.containsKey(tag)) {
                StickySingleLiveEvent liveEvent = new StickySingleLiveEvent();
                map2 = mEvents;
                StickySingleLiveEvent stickySingleLiveEvent = liveEvent;
                map2.put(tag, stickySingleLiveEvent);
            }
            LiveEventBase<? extends Object> liveEventBase = mEvents.get(tag);
            if (liveEventBase == null) break block1;
            liveEventBase.setValue(eventValue);
        }
    }

    public final <T> void postStickyEvent(@NotNull String tag, T eventValue) {
        block1: {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Map map2 = map = (Map)mEvents;
            if (!map2.containsKey(tag)) {
                StickyLiveEvent liveEvent = new StickyLiveEvent();
                map2 = mEvents;
                StickyLiveEvent stickyLiveEvent = liveEvent;
                map2.put(tag, stickyLiveEvent);
            }
            LiveEventBase<? extends Object> liveEventBase = mEvents.get(tag);
            if (liveEventBase == null) break block1;
            liveEventBase.setValue(eventValue);
        }
    }

    public final <T> void removeStickyEvent(@NotNull String tag) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Map map2 = map = (Map)mEvents;
        if (!map2.containsKey(tag)) {
            return;
        }
        mEvents.remove(tag);
    }

    @Nullable
    public final LiveEventBase<? extends Object> subscribeEvent(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (mEvents.containsKey(tag)) {
            return mEvents.get(tag);
        }
        return null;
    }

    @NotNull
    public final <T> LiveEventBase<T> subscribeLiveEvent(@NotNull String tag, @NotNull Class<T> type) {
        LiveEventBase liveEventBase;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (mEvents.containsKey(tag)) {
            LiveEvent liveEvent;
            try {
                LiveEventBase<? extends Object> liveEventBase2 = mEvents.get(tag);
                if (liveEventBase2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.insac.can.livebus.core.LiveEvent<T>");
                }
                liveEvent = (LiveEvent)liveEventBase2;
            }
            catch (Exception e) {
                throw (Throwable)new LiveBusException("LiveEvent casting exception! LiveEventBase saved on the bus doesn't have the LiveEvent type");
            }
            liveEventBase = liveEvent;
        } else {
            LiveEvent liveEvent = new LiveEvent();
            mEvents.put(tag, liveEvent);
            liveEventBase = liveEvent;
        }
        return liveEventBase;
    }

    @NotNull
    public final <T> LiveEventBase<T> subscribeSingleLiveEvent(@NotNull String tag, @NotNull Class<T> type) {
        LiveEventBase liveEventBase;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (mEvents.containsKey(tag)) {
            SingleLiveEvent singleLiveEvent;
            try {
                LiveEventBase<? extends Object> liveEventBase2 = mEvents.get(tag);
                if (liveEventBase2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.insac.can.livebus.core.SingleLiveEvent<T>");
                }
                singleLiveEvent = (SingleLiveEvent)liveEventBase2;
            }
            catch (Exception e) {
                throw (Throwable)new LiveBusException("LiveEvent casting exception! LiveEventBase saved on the bus doesn't have the SingleLiveEvent type");
            }
            liveEventBase = singleLiveEvent;
        } else {
            SingleLiveEvent liveEvent = new SingleLiveEvent();
            Map map = mEvents;
            SingleLiveEvent singleLiveEvent = liveEvent;
            map.put(tag, singleLiveEvent);
            liveEventBase = liveEvent;
        }
        return liveEventBase;
    }

    @NotNull
    public final <T> LiveEventBase<T> subscribeStickyLiveEvent(@NotNull String tag, @NotNull Class<T> type) {
        LiveEventBase liveEventBase;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (mEvents.containsKey(tag)) {
            StickyLiveEvent stickyLiveEvent;
            try {
                LiveEventBase<? extends Object> liveEventBase2 = mEvents.get(tag);
                if (liveEventBase2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.insac.can.livebus.core.StickyLiveEvent<T>");
                }
                stickyLiveEvent = (StickyLiveEvent)liveEventBase2;
            }
            catch (Exception e) {
                throw (Throwable)new LiveBusException("LiveEvent casting exception! LiveEventBase saved on the bus doesn't have the StickyLiveEvent type");
            }
            liveEventBase = stickyLiveEvent;
        } else {
            StickyLiveEvent liveEvent = new StickyLiveEvent();
            Map map = mEvents;
            StickyLiveEvent stickyLiveEvent = liveEvent;
            map.put(tag, stickyLiveEvent);
            liveEventBase = liveEvent;
        }
        return liveEventBase;
    }

    @NotNull
    public final <T> LiveEventBase<T> subscribeStickySingleLiveEvent(@NotNull String tag, @NotNull Class<T> type) {
        LiveEventBase liveEventBase;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (mEvents.containsKey(tag)) {
            StickySingleLiveEvent stickySingleLiveEvent;
            try {
                LiveEventBase<? extends Object> liveEventBase2 = mEvents.get(tag);
                if (liveEventBase2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.insac.can.livebus.core.StickySingleLiveEvent<T>");
                }
                stickySingleLiveEvent = (StickySingleLiveEvent)liveEventBase2;
            }
            catch (Exception e) {
                throw (Throwable)new LiveBusException("LiveEvent casting exception! LiveEventBase saved on the bus doesn't have the StickySingleLiveEvent type");
            }
            liveEventBase = stickySingleLiveEvent;
        } else {
            StickySingleLiveEvent liveEvent = new StickySingleLiveEvent();
            Map map = mEvents;
            StickySingleLiveEvent stickySingleLiveEvent = liveEvent;
            map.put(tag, stickySingleLiveEvent);
            liveEventBase = liveEvent;
        }
        return liveEventBase;
    }

    static {
        Companion = new Companion(null);
        mEvents = new HashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\tR>\u0010\u0003\u001a2\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u00060\u0004j\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/insac/can/livebus/core/LiveBus$Companion;", "", "()V", "mEvents", "Ljava/util/HashMap;", "", "Lcom/insac/can/livebus/core/LiveEventBase;", "Lkotlin/collections/HashMap;", "mInstance", "Lcom/insac/can/livebus/core/LiveBus;", "getInstance", "livebus_release"})
    public static final class Companion {
        @NotNull
        public final LiveBus getInstance() {
            if (mInstance == null) {
                mInstance = new LiveBus();
            }
            LiveBus liveBus = mInstance;
            if (liveBus == null) {
                Intrinsics.throwNpe();
            }
            return liveBus;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

