/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.dto;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class Query {
    private final String command;
    private final String database;
    private final boolean requiresPost;

    public Query(String command, String database) {
        this(command, database, false);
    }

    public Query(String command, String database, boolean requiresPost) {
        this.command = command;
        this.database = database;
        this.requiresPost = requiresPost;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandWithUrlEncoded() {
        return Query.encode(this.command);
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean requiresPost() {
        return this.requiresPost;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        return !(this.database == null ? other.database != null : !this.database.equals(other.database));
    }

    public static String encode(String command) {
        try {
            return URLEncoder.encode(command, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

