/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.impl.InfluxDBImpl;

public class BatchProcessor {
    private static final Logger LOG = Logger.getLogger(BatchProcessor.class.getName());
    protected final BlockingQueue<AbstractBatchEntry> queue = new LinkedBlockingQueue<AbstractBatchEntry>();
    private final ScheduledExecutorService scheduler;
    final InfluxDBImpl influxDB;
    final int actions;
    private final TimeUnit flushIntervalUnit;
    private final int flushInterval;

    public static Builder builder(InfluxDB influxDB) {
        return new Builder(influxDB);
    }

    BatchProcessor(InfluxDBImpl influxDB, ThreadFactory threadFactory, int actions, TimeUnit flushIntervalUnit, int flushInterval) {
        this.influxDB = influxDB;
        this.actions = actions;
        this.flushIntervalUnit = flushIntervalUnit;
        this.flushInterval = flushInterval;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BatchProcessor.this.write();
            }
        }, this.flushInterval, this.flushInterval, this.flushIntervalUnit);
    }

    void write() {
        try {
            if (this.queue.isEmpty()) {
                return;
            }
            HashMap batchKeyToBatchPoints = Maps.newHashMap();
            HashMap udpPortToBatchPoints = Maps.newHashMap();
            ArrayList batchEntries = new ArrayList(this.queue.size());
            this.queue.drainTo(batchEntries);
            for (AbstractBatchEntry abstractBatchEntry : batchEntries) {
                Point point = abstractBatchEntry.getPoint();
                if (abstractBatchEntry instanceof HttpBatchEntry) {
                    HttpBatchEntry httpBatchEntry = (HttpBatchEntry)HttpBatchEntry.class.cast(abstractBatchEntry);
                    String dbName = httpBatchEntry.getDb();
                    String rp = httpBatchEntry.getRp();
                    String batchKey = dbName + "_" + rp;
                    if (!batchKeyToBatchPoints.containsKey(batchKey)) {
                        BatchPoints batchPoints = BatchPoints.database(dbName).retentionPolicy(rp).build();
                        batchKeyToBatchPoints.put(batchKey, batchPoints);
                    }
                    ((BatchPoints)batchKeyToBatchPoints.get(batchKey)).point(point);
                    continue;
                }
                if (!(abstractBatchEntry instanceof UdpBatchEntry)) continue;
                UdpBatchEntry udpBatchEntry = (UdpBatchEntry)UdpBatchEntry.class.cast(abstractBatchEntry);
                int udpPort = udpBatchEntry.getUdpPort();
                if (!udpPortToBatchPoints.containsKey(udpPort)) {
                    ArrayList batchPoints = new ArrayList();
                    udpPortToBatchPoints.put(udpPort, batchPoints);
                }
                ((List)udpPortToBatchPoints.get(udpPort)).add(point.lineProtocol());
            }
            for (BatchPoints batchPoints : batchKeyToBatchPoints.values()) {
                this.influxDB.write(batchPoints);
            }
            for (Map.Entry entry : udpPortToBatchPoints.entrySet()) {
                for (String lineprotocolStr : (List)entry.getValue()) {
                    this.influxDB.write((int)((Integer)entry.getKey()), lineprotocolStr);
                }
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Batch could not be sent. Data will be lost", t);
        }
    }

    void put(AbstractBatchEntry batchEntry) {
        this.queue.add(batchEntry);
        if (this.queue.size() >= this.actions) {
            this.scheduler.submit(new Runnable(){

                @Override
                public void run() {
                    BatchProcessor.this.write();
                }
            });
        }
    }

    void flush() {
        this.write();
        this.scheduler.shutdown();
    }

    static class UdpBatchEntry
    extends AbstractBatchEntry {
        private final int udpPort;

        public UdpBatchEntry(Point point, int udpPort) {
            super(point);
            this.udpPort = udpPort;
        }

        public int getUdpPort() {
            return this.udpPort;
        }
    }

    static class HttpBatchEntry
    extends AbstractBatchEntry {
        private final String db;
        private final String rp;

        public HttpBatchEntry(Point point, String db, String rp) {
            super(point);
            this.db = db;
            this.rp = rp;
        }

        public String getDb() {
            return this.db;
        }

        public String getRp() {
            return this.rp;
        }
    }

    static abstract class AbstractBatchEntry {
        private final Point point;

        public AbstractBatchEntry(Point point) {
            this.point = point;
        }

        public Point getPoint() {
            return this.point;
        }
    }

    public static final class Builder {
        private final InfluxDBImpl influxDB;
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private int actions;
        private TimeUnit flushIntervalUnit;
        private int flushInterval;

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder(InfluxDB influxDB) {
            this.influxDB = (InfluxDBImpl)influxDB;
        }

        public Builder actions(int maxActions) {
            this.actions = maxActions;
            return this;
        }

        public Builder interval(int interval, TimeUnit unit) {
            this.flushInterval = interval;
            this.flushIntervalUnit = unit;
            return this;
        }

        public BatchProcessor build() {
            Preconditions.checkNotNull((Object)this.influxDB, (Object)"influxDB may not be null");
            Preconditions.checkArgument((this.actions > 0 ? 1 : 0) != 0, (Object)"actions should > 0");
            Preconditions.checkArgument((this.flushInterval > 0 ? 1 : 0) != 0, (Object)"flushInterval should > 0");
            Preconditions.checkNotNull((Object)((Object)this.flushIntervalUnit), (Object)"flushIntervalUnit may not be null");
            Preconditions.checkNotNull((Object)this.threadFactory, (Object)"threadFactory may not be null");
            return new BatchProcessor(this.influxDB, this.threadFactory, this.actions, this.flushIntervalUnit, this.flushInterval);
        }
    }
}

