/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.dto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Serie {
    private final String name;
    String[] columns;
    Object[][] points;

    Serie(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public List<Map<String, Object>> getRows() {
        ArrayList rows = Lists.newArrayList();
        for (Object[] point : this.points) {
            int column = 0;
            HashMap row = Maps.newHashMap();
            for (Object value : point) {
                row.put(this.columns[column], value);
                ++column;
            }
            rows.add(row);
        }
        return rows;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.name).add("c", Arrays.deepToString(this.columns)).add("p", Arrays.deepToString((Object[])this.points)).toString();
    }

    public static class Builder {
        private final String name;
        private final List<String> columns = Lists.newArrayList();
        private final List<List<Object>> valueRows = Lists.newArrayList();

        public Builder(String name) {
            this.name = name;
        }

        public Builder columns(String ... columnNames) {
            Preconditions.checkArgument(this.columns.isEmpty(), "You can only call columns() once.");
            this.columns.addAll(Arrays.asList(columnNames));
            return this;
        }

        public Builder values(Object ... values) {
            Preconditions.checkArgument(values.length == this.columns.size(), "Value count differs from column count.");
            this.valueRows.add(Arrays.asList(values));
            return this;
        }

        public Serie build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.name), "Serie name must not be null or empty.");
            Serie serie = new Serie(this.name);
            serie.columns = this.columns.toArray(new String[this.columns.size()]);
            Object[][] points = new Object[this.valueRows.size()][this.columns.size()];
            int row = 0;
            for (List<Object> values : this.valueRows) {
                points[row] = values.toArray();
                ++row;
            }
            serie.points = points;
            return serie;
        }
    }
}

