/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.infinispan.testcontainers.CountdownLatchLoggingConsumer;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;

public class InfinispanGenericContainer {
    private final GenericContainer genericContainer;
    private final String containerId;
    private boolean isKilled = false;

    public InfinispanGenericContainer(GenericContainer genericContainer) {
        this.containerId = genericContainer.getContainerId();
        this.genericContainer = genericContainer;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void pause() {
        this.dockerClient().pauseContainerCmd(this.containerId).exec();
    }

    public void resume() {
        this.dockerClient().unpauseContainerCmd(this.containerId).exec();
    }

    public void start() {
        if (!this.isRunning()) {
            this.dockerClient().startContainerCmd(this.containerId).exec();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.dockerClient().stopContainerCmd(this.containerId).exec();
        }
    }

    public void kill() {
        this.dockerClient().killContainerCmd(this.containerId).exec();
        this.genericContainer.stop();
    }

    public boolean isRunning() {
        InspectContainerResponse containerInfo = this.containerInfo();
        return containerInfo != null ? containerInfo.getState().getRunning() : false;
    }

    public boolean isPaused() {
        InspectContainerResponse containerInfo = this.containerInfo();
        return containerInfo != null ? containerInfo.getState().getPaused() : false;
    }

    public boolean isKilled() {
        return this.isKilled;
    }

    public void setKilled(boolean isKilled) {
        this.isKilled = isKilled;
    }

    public ContainerNetwork getContainerNetwork() {
        InspectContainerResponse containerInfo = this.containerInfo();
        if (containerInfo == null) {
            throw new NullPointerException(String.format("The requested container %s have an invalid state", this.containerId));
        }
        return (ContainerNetwork)containerInfo.getNetworkSettings().getNetworks().values().iterator().next();
    }

    public InetAddress getIpAddress() {
        return this.unchecked(() -> InetAddress.getByName(this.getNetworkIpAddress()));
    }

    <T> T unchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getNetworkIpAddress() {
        InspectContainerResponse containerInfo = this.containerInfo();
        if (containerInfo == null) {
            throw new NullPointerException(String.format("The requested container %s have an invalid state", this.containerId));
        }
        if (!containerInfo.getState().getRunning().booleanValue()) {
            throw new IllegalStateException("Server must be running");
        }
        ContainerNetwork network = (ContainerNetwork)containerInfo.getNetworkSettings().getNetworks().values().iterator().next();
        return network.getIpAddress();
    }

    public InspectContainerResponse containerInfo() {
        InspectContainerResponse containerInfo;
        try {
            containerInfo = this.dockerClient().inspectContainerCmd(this.containerId).exec();
        }
        catch (NotFoundException e) {
            containerInfo = null;
        }
        return containerInfo;
    }

    public String getLogs() {
        return this.genericContainer.getLogs();
    }

    public int getMappedPort(int port) {
        return this.genericContainer.getMappedPort(port);
    }

    public void withLogConsumer(CountdownLatchLoggingConsumer latch) {
        this.genericContainer.withLogConsumer((Consumer)((Object)latch));
    }

    private DockerClient dockerClient() {
        return DockerClientFactory.instance().client();
    }

    public GenericContainer getGenericContainer() {
        return this.genericContainer;
    }

    public void uploadCoverageInfoToHost(String containerPath, String destinationPath) {
        this.genericContainer.copyFileFromContainer(containerPath, destinationPath);
    }
}

