/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.annotations.impl.OriginatingClasses;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;
import org.infinispan.protostream.annotations.impl.types.XClass;

final class AnnotatedClassScanner {
    private TreeMap<String, TypeMirror> classes;
    private final Messager messager;
    private final Elements elements;
    private final Element builderElement;
    private final AutoProtoSchemaBuilder builderAnnotation;
    private final Set<String> basePackages;
    private final Set<TypeMirror> includedClasses = new LinkedHashSet<TypeMirror>();
    private final Set<TypeMirror> excludedClasses = new LinkedHashSet<TypeMirror>();
    private final PackageElement packageOfInitializer;
    private final String initializerClassName;
    private final String initializerFQClassName;

    AnnotatedClassScanner(Messager messager, Elements elements, Element builderElement, AutoProtoSchemaBuilder builderAnnotation) {
        this.messager = messager;
        this.elements = elements;
        this.builderElement = builderElement;
        this.builderAnnotation = builderAnnotation;
        try {
            builderAnnotation.includeClasses();
        }
        catch (MirroredTypesException mte) {
            this.includedClasses.addAll(mte.getTypeMirrors());
        }
        try {
            builderAnnotation.excludeClasses();
        }
        catch (MirroredTypesException mte) {
            this.excludedClasses.addAll(mte.getTypeMirrors());
        }
        this.basePackages = this.getBasePackages();
        if (!this.includedClasses.isEmpty()) {
            if (!this.excludedClasses.isEmpty()) {
                throw new AnnotationProcessingException(builderElement, "@AutoProtoSchemaBuilder.includeClasses and @AutoProtoSchemaBuilder.excludeClasses are mutually exclusive", new Object[0]);
            }
            if (!this.basePackages.isEmpty()) {
                throw new AnnotationProcessingException(builderElement, "@AutoProtoSchemaBuilder.includeClasses and @AutoProtoSchemaBuilder.value/basePackages are mutually exclusive", new Object[0]);
            }
        }
        for (TypeMirror c : this.excludedClasses) {
            TypeElement typeElement = (TypeElement)((DeclaredType)c).asElement();
            PackageElement packageOfClass = elements.getPackageOf(typeElement);
            if (this.isPackageIncluded(packageOfClass)) continue;
            String errMsg = String.format("@AutoProtoSchemaBuilder.excludeClasses and @AutoProtoSchemaBuilder.value/basePackages are conflicting. Class '%s' must belong to a base package.", typeElement.getQualifiedName());
            throw new AnnotationProcessingException(builderElement, errMsg, new Object[0]);
        }
        this.packageOfInitializer = elements.getPackageOf(builderElement);
        this.initializerClassName = builderAnnotation.className().isEmpty() ? builderElement.getSimpleName() + "Impl" : builderAnnotation.className();
        this.initializerFQClassName = this.packageOfInitializer.isUnnamed() ? this.initializerClassName : this.packageOfInitializer.getQualifiedName().toString() + '.' + this.initializerClassName;
    }

    String getInitializerClassName() {
        return this.initializerClassName;
    }

    String getInitializerFQClassName() {
        return this.initializerFQClassName;
    }

    Collection<? extends TypeMirror> getClasses() {
        return this.classes.values();
    }

    void discoverClasses(RoundEnvironment roundEnv) throws AnnotationProcessingException {
        this.classes = new TreeMap();
        if (this.includedClasses.isEmpty()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoField.class)) {
                this.visitProtoField(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoFactory.class)) {
                this.visitProtoFactory(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnumValue.class)) {
                this.visitProtoEnumValue(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnum.class)) {
                this.visitProtoEnum(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoMessage.class)) {
                this.visitProtoMessage(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoName.class)) {
                this.visitProtoName(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoTypeId.class)) {
                this.visitProtoTypeId(element);
            }
            for (TypeElement typeElement : this.getOriginatingClasses()) {
                this.visitTypeElement(typeElement);
            }
        } else {
            for (TypeMirror typeMirror : this.includedClasses) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.collectClasses(typeElement);
            }
        }
    }

    private void visitTypeElement(TypeElement e) {
        if (e.getAnnotation(ProtoTypeId.class) != null) {
            this.visitProtoTypeId(e);
        }
        if (e.getAnnotation(ProtoName.class) != null) {
            this.visitProtoName(e);
        }
        if (e.getAnnotation(ProtoMessage.class) != null) {
            this.visitProtoMessage(e);
        }
        if (e.getAnnotation(ProtoEnum.class) != null) {
            this.visitProtoEnum(e);
        }
        for (Element element : e.getEnclosedElements()) {
            if (element.getAnnotation(ProtoField.class) != null) {
                this.visitProtoField(element);
            }
            if (element.getAnnotation(ProtoEnumValue.class) != null) {
                this.visitProtoEnumValue(element);
            }
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) continue;
            this.visitTypeElement((TypeElement)element);
        }
    }

    private void visitProtoFactory(Element e) {
        Element enclosingElement = e.getEnclosingElement();
        if (e.getKind() != ElementKind.METHOD && e.getKind() != ElementKind.CONSTRUCTOR || enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoFactory can only be applied to constructors and methods.", new Object[0]);
        }
        this.collectClasses((TypeElement)enclosingElement);
    }

    private void visitProtoField(Element e) {
        Element enclosingElement = e.getEnclosingElement();
        if (e.getKind() != ElementKind.METHOD && e.getKind() != ElementKind.FIELD || enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoField can only be applied to fields and methods.", new Object[0]);
        }
        this.collectClasses((TypeElement)enclosingElement);
    }

    private void visitProtoEnumValue(Element e) {
        Element enclosingElement = e.getEnclosingElement();
        if (e.getKind() != ElementKind.ENUM_CONSTANT || enclosingElement.getKind() != ElementKind.ENUM) {
            throw new AnnotationProcessingException(e, "@ProtoEnumValue can only be applied to enum constants.", new Object[0]);
        }
        this.collectClasses((TypeElement)enclosingElement);
    }

    private void visitProtoTypeId(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE && e.getKind() != ElementKind.ENUM) {
            throw new AnnotationProcessingException(e, "@ProtoTypeId can only be applied to classes, interfaces and enums.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private void visitProtoName(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE && e.getKind() != ElementKind.ENUM) {
            throw new AnnotationProcessingException(e, "@ProtoName can only be applied to classes, interfaces and enums.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private void visitProtoMessage(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoMessage can only be applied to classes and interfaces.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private void visitProtoEnum(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoEnum can only be applied to enums.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private Set<TypeElement> getOriginatingClasses() {
        OriginatingClasses originatingClasses;
        Set<TypeElement> typeElements = Collections.emptySet();
        TypeElement initializer = this.elements.getTypeElement(this.initializerFQClassName);
        if (initializer != null && (originatingClasses = initializer.getAnnotation(OriginatingClasses.class)) != null) {
            typeElements = new HashSet<TypeElement>(originatingClasses.value().length);
            for (String name : originatingClasses.value()) {
                TypeElement typeElement = this.elements.getTypeElement(name);
                if (typeElement == null) continue;
                typeElements.add(typeElement);
            }
        }
        return typeElements;
    }

    boolean isClassAcceptable(XClass c) {
        String canonicalName = c.getCanonicalName();
        if (this.classes.containsKey(canonicalName)) {
            return true;
        }
        TypeElement typeElement = this.elements.getTypeElement(canonicalName);
        TypeMirror type = typeElement.asType();
        if (this.excludedClasses.contains(type)) {
            return false;
        }
        if (this.includedClasses.contains(type)) {
            return true;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (!this.isPackageIncluded(packageOfElement)) {
            return false;
        }
        return this.includedClasses.isEmpty() || this.builderAnnotation.autoImportClasses();
    }

    private Set<String> getBasePackages() {
        if (this.builderAnnotation.value().length == 0 && this.builderAnnotation.basePackages().length == 0) {
            return Collections.emptySet();
        }
        if (this.builderAnnotation.value().length != 0 && this.builderAnnotation.basePackages().length != 0) {
            throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.value and @AutoProtoSchemaBuilder.basePackages are mutually exclusive", new Object[0]);
        }
        String[] basePackages = this.builderAnnotation.value();
        String annotationMember = "value";
        if (basePackages.length == 0) {
            annotationMember = "basePackages";
            basePackages = this.builderAnnotation.basePackages();
        }
        HashSet<String> packages = new HashSet<String>(basePackages.length);
        for (String p : basePackages) {
            if (!SourceVersion.isName(p)) {
                throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.%s contains an invalid package name : \"%s\"", annotationMember, p);
            }
            packages.add(p);
        }
        return packages;
    }

    private void collectClasses(TypeElement typeElement) {
        TypeMirror type = typeElement.asType();
        if (this.excludedClasses.contains(type)) {
            return;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (!this.isPackageIncluded(packageOfElement)) {
            return;
        }
        if (this.includedClasses.isEmpty()) {
            if (typeElement.getKind() == ElementKind.INTERFACE || typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return;
            }
            if (packageOfElement.isUnnamed() && !this.packageOfInitializer.isUnnamed() || !packageOfElement.equals(this.packageOfInitializer) && !this.isPublicElement(typeElement)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Type %s is not visible to %s so it is ignored!", typeElement.getQualifiedName(), ((QualifiedNameable)this.builderElement).getQualifiedName()), this.builderElement);
                return;
            }
        }
        this.classes.putIfAbsent(typeElement.getQualifiedName().toString(), type);
    }

    private boolean isPublicElement(TypeElement typeElement) {
        block2: {
            Element e = typeElement;
            do {
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    return false;
                }
                if ((e = e.getEnclosingElement()) == null || e.getKind() == ElementKind.PACKAGE) break block2;
            } while (e.getKind() == ElementKind.CLASS || e.getKind() == ElementKind.INTERFACE || e.getKind() == ElementKind.ENUM);
            return false;
        }
        return true;
    }

    private boolean isPackageIncluded(PackageElement packageElement) {
        if (this.basePackages.isEmpty()) {
            return true;
        }
        String p = packageElement.getQualifiedName().toString();
        while (true) {
            if (this.basePackages.contains(p)) {
                return true;
            }
            int pos = p.lastIndexOf(46);
            if (pos == -1) break;
            p = p.substring(0, pos);
        }
        return false;
    }
}

