/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.processor.CompileTimeProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.processor.ServiceLoaderFileGenerator;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.processor.types.MirrorClassFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XMethod;

@SupportedOptions(value={"debug"})
@SupportedAnnotationTypes(value={"org.infinispan.protostream.annotations.AutoProtoSchemaBuilder"})
public final class AutoProtoSchemaBuilderAnnotationProcessor
extends AbstractProcessor {
    public static final String PROTO_SCHEMA_TOOL_ANNOTATION_NAME = "org.infinispan.protostream.annotations.AutoProtoSchemaBuilder";
    public static final String DEBUG_OPTION = "debug";
    private final ServiceLoaderFileGenerator serviceLoaderFileGenerator = new ServiceLoaderFileGenerator(SerializationContextInitializer.class);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void reportError(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, formatted, e);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, formatted);
        }
    }

    private void reportWarning(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, formatted, e);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, formatted);
        }
    }

    private void log(String message) {
        if (this.processingEnv.getOptions().containsKey(DEBUG_OPTION)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            boolean claimed;
            boolean bl = claimed = annotations.size() == 1 && annotations.iterator().next().getQualifiedName().contentEquals(PROTO_SCHEMA_TOOL_ANNOTATION_NAME);
            if (!claimed && !roundEnv.processingOver()) {
                return false;
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(AutoProtoSchemaBuilder.class)) {
                if (element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.CLASS) {
                    this.reportError(element, "@AutoProtoSchemaBuilder can only be applied to classes and interfaces.", new Object[0]);
                    return true;
                }
                TypeElement annotatedTypeElement = (TypeElement)element;
                AutoProtoSchemaBuilder annotation = annotatedTypeElement.getAnnotation(AutoProtoSchemaBuilder.class);
                Collection<? extends TypeMirror> classes = this.getClassesToProcess(roundEnv, annotatedTypeElement, annotation);
                try {
                    this.process(annotatedTypeElement, annotation, classes);
                }
                catch (ProtoSchemaBuilderException e) {
                    this.reportError(element, "%s", e.getMessage());
                    return true;
                }
            }
            if (roundEnv.processingOver()) {
                this.serviceLoaderFileGenerator.generate(this.processingEnv.getFiler());
            }
        }
        catch (Exception e) {
            this.reportError(null, "@AutoProtoSchemaBuilder processor threw an exception: %s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
        }
        return true;
    }

    private Collection<? extends TypeMirror> getClassesToProcess(RoundEnvironment roundEnv, TypeElement e, AutoProtoSchemaBuilder annotation) {
        List<Object> specifiedClasses = Collections.emptyList();
        try {
            annotation.classes();
        }
        catch (MirroredTypesException mte) {
            specifiedClasses = mte.getTypeMirrors();
        }
        TreeMap<String, TypeMirror> classes = new TreeMap<String, TypeMirror>();
        if (specifiedClasses.isEmpty()) {
            TypeElement typeElement;
            Element enclosingElement;
            HashSet<String> packages = annotation.packages().length != 0 ? new HashSet<String>(Arrays.asList(annotation.packages())) : null;
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoField.class)) {
                enclosingElement = element.getEnclosingElement();
                if (enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) continue;
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.filterByPackage(classes, typeElement2, packages);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnumValue.class)) {
                enclosingElement = element.getEnclosingElement();
                if (element.getKind() != ElementKind.ENUM_CONSTANT || enclosingElement.getKind() != ElementKind.ENUM) {
                    this.reportError(element, "@ProtoEnumValue can only be applied to enum constants.", new Object[0]);
                }
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.filterByPackage(classes, typeElement2, packages);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnum.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    this.reportError(element, "@ProtoEnum can only be applied to enums.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, packages);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoMessage.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    this.reportError(element, "@ProtoMessage can only be applied to classes and interfaces.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, packages);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoName.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM) {
                    this.reportError(element, "@ProtoName can only be applied to classes, interfaces and enums.", new Object[0]);
                }
                typeElement = (TypeElement)element.getEnclosingElement();
                this.filterByPackage(classes, typeElement, packages);
            }
        } else {
            if (annotation.packages().length != 0) {
                this.reportError(e, "@AutoProtoSchemaBuilder.packages cannot be specified if @AutoProtoSchemaBuilder.classes is not empty.", new Object[0]);
            }
            for (TypeMirror typeMirror : specifiedClasses) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                String fqn = typeElement.getQualifiedName().toString();
                classes.putIfAbsent(fqn, typeMirror);
            }
        }
        return classes.values();
    }

    private void filterByPackage(Map<String, TypeMirror> classes, TypeElement typeElement, Set<String> packages) {
        PackageElement packageOfElement;
        String packageName;
        if (typeElement.getKind() == ElementKind.INTERFACE || typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            return;
        }
        String fqn = typeElement.getQualifiedName().toString();
        if (packages != null && !packages.contains(packageName = (packageOfElement = this.processingEnv.getElementUtils().getPackageOf(typeElement)).getQualifiedName().toString())) {
            return;
        }
        classes.putIfAbsent(fqn, typeElement.asType());
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void process(TypeElement typeElement, AutoProtoSchemaBuilder annotation, Collection<? extends TypeMirror> classes) throws IOException {
        if (typeElement.getNestingKind() == NestingKind.LOCAL || typeElement.getNestingKind() == NestingKind.ANONYMOUS) {
            this.reportError(typeElement, "Classes annotated with @AutoProtoSchemaBuilder must not be local or anonymous.", new Object[0]);
            return;
        }
        if (typeElement.getNestingKind() == NestingKind.MEMBER && !typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            this.reportError(typeElement, "Nested classes annotated with @AutoProtoSchemaBuilder must be static.", new Object[0]);
            return;
        }
        if (typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.FINAL)) {
            this.reportError(typeElement, "Classes annotated with @AutoProtoSchemaBuilder must not be final.", new Object[0]);
            return;
        }
        if (!annotation.className().isEmpty() && !SourceVersion.isIdentifier(annotation.className())) {
            this.reportError(typeElement, "Invalid 'AutoProtoSchemaBuilder.className' annotation attribute. Should be a valid Java class name and must not be fully qualified.", new Object[0]);
            return;
        }
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(typeElement);
        String packageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String initializerClassName = annotation.className().isEmpty() ? typeElement.getSimpleName() + "Impl" : annotation.className();
        String protobufPackageName = annotation.packageName().isEmpty() ? null : annotation.packageName();
        MirrorClassFactory typeFactory = new MirrorClassFactory(this.processingEnv);
        XClass annotatedType = typeFactory.fromTypeMirror(typeElement.asType());
        this.warnOverrideExistingMethod(annotatedType, "getProtoFileName", new XClass[0]);
        this.warnOverrideExistingMethod(annotatedType, "getProtoFile", new XClass[0]);
        XClass serializationContextClass = typeFactory.fromClass(SerializationContext.class);
        this.warnOverrideExistingMethod(annotatedType, "registerSchema", serializationContextClass);
        this.warnOverrideExistingMethod(annotatedType, "registerMarshallers", serializationContextClass);
        Set xclasses = classes.stream().map(typeFactory::fromTypeMirror).collect(Collectors.toCollection(LinkedHashSet::new));
        SerializationContext serCtx = ProtobufUtil.newSerializationContext();
        LinkedHashSet<String> generatedClasses = new LinkedHashSet<String>();
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(typeFactory, this.processingEnv, serCtx, annotation.fileName(), protobufPackageName, xclasses, annotation.autoImportClasses(), generatedClasses);
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        this.writeSerializationContextInitializerSourceFile(annotation, typeElement, classes, packageName, initializerClassName, annotation.fileName(), schemaSrc, generatedClasses);
    }

    private void warnOverrideExistingMethod(XClass xclass, String methodName, XClass ... argTypes) {
        XMethod method = xclass.getMethod(methodName, argTypes);
        if (method != null && !Modifier.isAbstract(method.getModifiers())) {
            this.reportWarning(((HasModelElement)method).getElement(), "@AutoProtoSchemaBuilder will inadvertently override your %s.%s method.", method.getDeclaringClass().getName(), method.getName());
        }
    }

    private void writeSerializationContextInitializerSourceFile(AutoProtoSchemaBuilder annotation, TypeElement annotatedElement, Collection<? extends TypeMirror> classes, String packageName, String initializerClassName, String fileName, String schemaSrc, Set<String> generatedClasses) throws IOException {
        JavaFileObject javaFileObject;
        Filer filer = this.processingEnv.getFiler();
        Types types = this.processingEnv.getTypeUtils();
        Element[] originatingElements = new Element[classes.size() + 1];
        int i = 0;
        for (TypeMirror typeMirror : classes) {
            originatingElements[i++] = types.asElement(typeMirror);
        }
        originatingElements[i] = annotatedElement;
        if (!annotation.filePath().isEmpty()) {
            this.writeSchema(annotation.filePath(), fileName, schemaSrc, originatingElements);
        }
        String initializerFqn = packageName != null ? packageName + '.' + initializerClassName : initializerClassName;
        try {
            javaFileObject = filer.createSourceFile(initializerFqn, originatingElements);
        }
        catch (FilerException fe) {
            this.reportError(annotatedElement, fe.getMessage(), new Object[0]);
            return;
        }
        IndentWriter iw = new IndentWriter();
        iw.append((CharSequence)"/*\n");
        iw.append((CharSequence)" Generated by ").append((CharSequence)this.getClass().getName()).append((CharSequence)"\n");
        iw.append((CharSequence)" at ").append((CharSequence)String.valueOf(Calendar.getInstance().getTime())).append((CharSequence)"\n");
        iw.append((CharSequence)" from class ").append((CharSequence)annotatedElement.getQualifiedName()).append((CharSequence)"\n");
        iw.append((CharSequence)" annotated with ").append((CharSequence)String.valueOf(annotation)).append((CharSequence)"\n");
        iw.append((CharSequence)" */\n\n");
        if (packageName != null) {
            iw.append((CharSequence)"package ").append((CharSequence)packageName).append((CharSequence)";\n\n");
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedBy(iw);
        iw.append((CharSequence)"public class ").append((CharSequence)initializerClassName);
        iw.append((CharSequence)(annotatedElement.getKind() == ElementKind.INTERFACE ? " implements " : " extends ")).append((CharSequence)annotatedElement.getQualifiedName()).append((CharSequence)" {\n\n");
        iw.inc();
        if (annotation.filePath().isEmpty()) {
            iw.append((CharSequence)"private static final String PROTO_SCHEMA = ").append((CharSequence)this.makeStringLiteral(schemaSrc)).append((CharSequence)";\n\n");
        }
        iw.append((CharSequence)"@Override\npublic String getProtoFileName() { return \"").append((CharSequence)fileName).append((CharSequence)"\"; }\n\n");
        iw.append((CharSequence)"@Override\npublic String getProtoFile() { return ");
        if (annotation.filePath().isEmpty()) {
            iw.append((CharSequence)"PROTO_SCHEMA");
        } else {
            iw.append((CharSequence)"org.infinispan.protostream.FileDescriptorSource.getResourceAsString(getClass(), getProtoFileName())");
        }
        iw.append((CharSequence)"; }\n\n");
        iw.append((CharSequence)"@Override\n");
        iw.append((CharSequence)"public void registerSchema(org.infinispan.protostream.SerializationContext serCtx) throws java.io.IOException {\n");
        iw.inc();
        if (annotation.filePath().isEmpty()) {
            iw.append((CharSequence)"serCtx.registerProtoFiles(org.infinispan.protostream.FileDescriptorSource.fromString(getProtoFileName(), PROTO_SCHEMA));\n");
        } else {
            String resourceFile = annotation.filePath().isEmpty() ? fileName : annotation.filePath().replace('.', '/') + '/' + fileName;
            iw.append((CharSequence)"serCtx.registerProtoFiles(org.infinispan.protostream.FileDescriptorSource.fromResources(\"").append((CharSequence)resourceFile).append((CharSequence)"\"));\n");
        }
        iw.dec();
        iw.append((CharSequence)"}\n\n");
        iw.append((CharSequence)"@Override\n");
        iw.append((CharSequence)"public void registerMarshallers(org.infinispan.protostream.SerializationContext serCtx) {\n");
        iw.inc();
        for (String name : generatedClasses) {
            iw.append((CharSequence)"serCtx.registerMarshaller(new ").append((CharSequence)name).append((CharSequence)"());\n");
        }
        iw.dec();
        iw.append((CharSequence)"}\n");
        iw.dec();
        iw.append((CharSequence)"}\n");
        try (PrintWriter out = new PrintWriter(javaFileObject.openWriter());){
            out.print(iw.toString());
        }
        if (annotation.service()) {
            this.serviceLoaderFileGenerator.addProvider(initializerFqn, annotatedElement);
        }
    }

    private void writeSchema(String filePath, String fileName, String schemaSrc, Element[] originatingElements) throws IOException {
        String pkg = filePath;
        if (pkg.startsWith("/")) {
            pkg = pkg.substring(1);
        }
        pkg = pkg.replace('/', '.');
        FileObject schemaFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, pkg, fileName, originatingElements);
        try (PrintWriter out = new PrintWriter(schemaFile.openWriter());){
            out.print(schemaSrc);
        }
    }

    static void addGeneratedBy(IndentWriter iw) {
        String ISO8601Date = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        iw.append((CharSequence)"@javax.annotation.Generated(value=\"").append((CharSequence)AutoProtoSchemaBuilderAnnotationProcessor.class.getName()).append((CharSequence)"\", date=\"").append((CharSequence)ISO8601Date).append((CharSequence)"\",\n      comments=\"Please do not edit this file\")\n");
    }

    private String makeStringLiteral(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append('\"');
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n\" +\n\"");
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private String makeClassName(TypeElement e) {
        return this.makeNestedClassName(e, e.getSimpleName().toString());
    }

    private String makeNestedClassName(TypeElement e, String className) {
        Element enclosingElement = e.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)enclosingElement;
            return packageElement.isUnnamed() ? className : packageElement.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.makeNestedClassName(typeElement, typeElement.getSimpleName() + "$" + className);
    }
}

