/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.schema;

import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.tools.schema.TreeNode;
import org.infinispan.tools.schema.TreeWalker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractTreeWalker
implements TreeWalker {
    protected final Log log = LogFactory.getLog(this.getClass());

    public void levelOrderTraverse(TreeNode root) {
        LinkedBlockingQueue<TreeNode> q = new LinkedBlockingQueue<TreeNode>();
        q.add(root);
        while (!q.isEmpty()) {
            TreeNode treeNode = (TreeNode)q.poll();
            treeNode.accept(this);
            if (!treeNode.hasChildren()) continue;
            q.addAll(treeNode.getChildren());
        }
    }

    public void preOrderTraverse(TreeNode node) {
        node.accept(this);
        if (node.hasChildren()) {
            for (TreeNode child : node.getChildren()) {
                this.preOrderTraverse(child);
            }
        }
    }

    public void postOrderTraverse(TreeNode node) {
        if (node.hasChildren()) {
            for (TreeNode child : node.getChildren()) {
                this.preOrderTraverse(child);
            }
        }
        node.accept(this);
    }
}

