/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.schema;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSComplexType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.infinispan.tools.schema.AbstractTreeWalker;
import org.infinispan.tools.schema.TreeWalker;

public class TreeNode
implements Iterable<TreeNode>,
Comparable<TreeNode> {
    private final String name;
    private TreeNode parent;
    private final Set<TreeNode> children = new HashSet<TreeNode>();
    private XSComplexType type;
    private final Set<XSAttributeDecl> attributes = new HashSet<XSAttributeDecl>();
    private Class<?> clazz;

    public TreeNode(String name, TreeNode parent) {
        this.name = name;
        this.parent = parent;
    }

    public TreeNode() {
        this.name = "";
        this.parent = null;
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        if (this.getParent() == null) {
            return -1;
        }
        return 1 + this.getParent().getDepth();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasChild(String name) {
        for (TreeNode treeNode : this.children) {
            if (!treeNode.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Set<TreeNode> getChildren() {
        return this.children;
    }

    public void detach() {
        this.parent.getChildren().remove(this);
        this.parent = null;
    }

    public void accept(TreeWalker tw) {
        tw.visitNode(this);
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public void setBeanClass(Class<?> bean) {
        this.clazz = bean;
    }

    public XSComplexType getType() {
        return this.type;
    }

    public void setType(XSComplexType type) {
        this.type = type;
    }

    public void addAttribute(XSAttributeDecl att) {
        this.attributes.add(att);
    }

    public Set<XSAttributeDecl> getAttributes() {
        return this.attributes;
    }

    @Override
    public Iterator<TreeNode> iterator() {
        return new TreeIterator();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TreeNode)) {
            return false;
        }
        TreeNode tn = (TreeNode)other;
        return this.parent.name != null && tn.parent != null && this.parent.name.equals(tn.parent.name) && this.name.equals(tn.name);
    }

    @Override
    public int compareTo(TreeNode o) {
        return this.name.compareTo(o.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.parent != null && this.parent.name != null ? this.parent.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name;
    }

    private class TreeIterator
    extends AbstractTreeWalker
    implements Iterator<TreeNode>,
    Iterable<TreeNode> {
        private List<TreeNode> nodes = new ArrayList<TreeNode>();
        private Iterator<TreeNode> i;

        private TreeIterator() {
            this.preOrderTraverse(TreeNode.this);
            Collections.sort(this.nodes);
            this.i = this.nodes.iterator();
        }

        @Override
        public Iterator<TreeNode> iterator() {
            return this.nodes.iterator();
        }

        @Override
        public void visitNode(TreeNode treeNode) {
            this.nodes.add(treeNode);
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public TreeNode next() {
            return this.i.next();
        }

        @Override
        public void remove() {
        }
    }
}

