/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.html;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlGenerator {
    String encoding;
    String title;
    String bottom;
    String footer;
    String header;
    String metaDescription;
    List<String> metaKeywords;

    public HtmlGenerator(String encoding, String title, String bottom, String footer, String header, String metaDescription, List<String> metaKeywords) {
        this.encoding = encoding;
        this.title = title;
        this.footer = footer;
        this.header = header;
        this.bottom = bottom;
        this.metaDescription = metaDescription;
        this.metaKeywords = metaKeywords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateHtml(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = this.isValid(this.encoding) ? new OutputStreamWriter((OutputStream)fos, this.encoding) : new OutputStreamWriter(fos);
        PrintWriter writer = new PrintWriter(osw);
        try {
            writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            writer.println("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
            writer.println("<HEAD>");
            if (this.isValid(this.metaDescription)) {
                writer.println("<META NAME=\"description\" content=\"" + this.metaDescription + "\" />");
            }
            if (this.metaKeywords != null && !this.metaKeywords.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<META NAME=\"keywords\" content=\"");
                for (String keyword : this.metaKeywords) {
                    sb.append(keyword).append(", ");
                }
                sb.append("\" />");
            }
            writer.println("<TITLE>");
            writer.println(this.title);
            writer.println("</TITLE>");
            writer.println("<LINK REL=\"stylesheet\" HREF=\"stylesheet.css\" TYPE=\"text/css\"/>");
            writer.println("</HEAD>");
            writer.println("<BODY>");
            if (this.isValid(this.header)) {
                writer.println(this.header);
                writer.println("<HR />");
            }
            writer.println(this.generateContents());
            if (this.isValid(this.bottom)) {
                writer.println("<HR />");
                writer.println(this.bottom);
            }
            if (this.isValid(this.footer)) {
                writer.println(this.footer);
            }
            writer.println("</BODY>");
            writer.println("</HTML>");
        }
        finally {
            writer.close();
            osw.close();
            fos.close();
        }
    }

    protected abstract String generateContents();

    protected boolean isValid(String s) {
        return s != null && !s.trim().equals("");
    }
}

