/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan8;

import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractMigratorExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ExternalizerTable;

@Immutable
class ListExternalizer
extends AbstractMigratorExternalizer<List> {
    private static final int ARRAY_LIST = 0;
    private static final int LINKED_LIST = 1;

    public ListExternalizer() {
        super(Set.of(ArrayList.class, LinkedList.class, ListExternalizer.getPrivateArrayListClass()), (Integer)ExternalizerTable.ARRAY_LIST);
    }

    @Override
    public List readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            }
            case 1: {
                return (List)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new LinkedList());
            }
        }
        throw new IllegalStateException("Unknown List type: " + magicNumber);
    }

    private static Class<List> getPrivateArrayListClass() {
        return Util.loadClass((String)"java.util.Arrays$ArrayList", (ClassLoader)List.class.getClassLoader());
    }
}

