/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import com.google.errorprone.annotations.Immutable;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractMigratorExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.Ids;

@Immutable
public class EnumSetExternalizer
extends AbstractMigratorExternalizer<Set> {
    private static final int UNKNOWN_ENUM_SET = 0;
    private static final int ENUM_SET = 1;
    private static final int REGULAR_ENUM_SET = 2;
    private static final int JUMBO_ENUM_SET = 3;
    private static final int MINI_ENUM_SET = 4;
    private static final int HUGE_ENUM_SET = 5;

    public EnumSetExternalizer() {
        super(EnumSetExternalizer.getClasses(), Ids.ENUM_SET_ID);
    }

    @Override
    public Set readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        if (magicNumber == 0) {
            return (Set)input.readObject();
        }
        EnumSet<Enum> enumSet = null;
        int size = UnsignedNumeric.readUnsignedInt((DataInput)input);
        block3: for (int i = 0; i < size; ++i) {
            switch (magicNumber) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (i == 0) {
                        enumSet = EnumSet.of((Enum)input.readObject());
                        continue block3;
                    }
                    enumSet.add((Enum)input.readObject());
                }
            }
        }
        return enumSet;
    }

    public static Set<Class<? extends Set>> getClasses() {
        HashSet<Class<? extends Set>> set = new HashSet<Class<? extends Set>>();
        set.add(EnumSet.class);
        EnumSetExternalizer.addEnumSetType(EnumSetExternalizer.getRegularEnumSetClass(), set);
        EnumSetExternalizer.addEnumSetType(EnumSetExternalizer.getJumboEnumSetClass(), set);
        EnumSetExternalizer.addEnumSetType(EnumSetExternalizer.getMiniEnumSetClass(), set);
        EnumSetExternalizer.addEnumSetType(EnumSetExternalizer.getHugeEnumSetClass(), set);
        return set;
    }

    private static void addEnumSetType(Class<? extends Set> clazz, Set<Class<? extends Set>> typeSet) {
        if (clazz != null) {
            typeSet.add(clazz);
        }
    }

    private static Class<EnumSet> getJumboEnumSetClass() {
        return EnumSetExternalizer.getEnumSetClass("java.util.JumboEnumSet");
    }

    private static Class<EnumSet> getRegularEnumSetClass() {
        return EnumSetExternalizer.getEnumSetClass("java.util.RegularEnumSet");
    }

    private static Class<EnumSet> getMiniEnumSetClass() {
        return EnumSetExternalizer.getEnumSetClass("java.util.MiniEnumSet");
    }

    private static Class<EnumSet> getHugeEnumSetClass() {
        return EnumSetExternalizer.getEnumSetClass("java.util.HugeEnumSet");
    }

    private static Class<EnumSet> getEnumSetClass(String className) {
        try {
            return Util.loadClassStrict((String)className, (ClassLoader)EnumSet.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

