/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.metadata.Metadata;

public class MetadataTransientMortalCacheValueExternalizer
implements AdvancedExternalizer<MetadataTransientMortalCacheValue> {
    public Set<Class<? extends MetadataTransientMortalCacheValue>> getTypeClasses() {
        return Collections.singleton(MetadataTransientMortalCacheValue.class);
    }

    public Integer getId() {
        return 45;
    }

    public void writeObject(ObjectOutput output, MetadataTransientMortalCacheValue icv) throws IOException {
        output.writeObject(icv.getValue());
        output.writeObject(icv.getMetadata());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)icv.getCreated());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)icv.getLastUsed());
    }

    public MetadataTransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object value = input.readObject();
        Metadata metadata = (Metadata)input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        return new MetadataTransientMortalCacheValue(value, metadata, created, lastUsed);
    }
}

