/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan9;

import java.io.EOFException;
import java.io.IOException;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.BytesObjectInput;

final class Primitives {
    private static final int ID_BYTE_ARRAY = 1;
    private static final int ID_STRING = 2;
    private static final int ID_BOOLEAN_OBJ = 16;
    private static final int ID_BYTE_OBJ = 17;
    private static final int ID_CHAR_OBJ = 18;
    private static final int ID_DOUBLE_OBJ = 19;
    private static final int ID_FLOAT_OBJ = 20;
    private static final int ID_INT_OBJ = 21;
    private static final int ID_LONG_OBJ = 22;
    private static final int ID_SHORT_OBJ = 23;
    private static final int ID_BOOLEAN_ARRAY = 24;
    private static final int ID_CHAR_ARRAY = 25;
    private static final int ID_DOUBLE_ARRAY = 26;
    private static final int ID_FLOAT_ARRAY = 27;
    private static final int ID_INT_ARRAY = 28;
    private static final int ID_LONG_ARRAY = 29;
    private static final int ID_SHORT_ARRAY = 30;
    private static final int ID_ARRAY_EMPTY = 40;
    private static final int ID_ARRAY_SMALL = 41;
    private static final int ID_ARRAY_MEDIUM = 42;
    private static final int ID_ARRAY_LARGE = 43;
    static final int SMALL_ARRAY_MIN = 1;
    static final int MEDIUM_ARRAY_MIN = 257;

    private Primitives() {
    }

    static Object readPrimitive(BytesObjectInput in) throws IOException {
        int subId = in.readUnsignedByte();
        return Primitives.readRawPrimitive(in, subId);
    }

    static Object readRawPrimitive(BytesObjectInput in, int subId) throws IOException {
        switch (subId) {
            case 1: {
                return Primitives.readByteArray(in);
            }
            case 2: {
                return in.readString();
            }
            case 16: {
                return in.readBoolean();
            }
            case 17: {
                return in.readByte();
            }
            case 18: {
                return Character.valueOf(in.readChar());
            }
            case 19: {
                return in.readDouble();
            }
            case 20: {
                return Float.valueOf(in.readFloat());
            }
            case 21: {
                return in.readInt();
            }
            case 22: {
                return in.readLong();
            }
            case 23: {
                return in.readShort();
            }
            case 24: {
                return Primitives.readBooleanArray(in);
            }
            case 25: {
                return Primitives.readCharArray(in);
            }
            case 26: {
                return Primitives.readDoubleArray(in);
            }
            case 27: {
                return Primitives.readFloatArray(in);
            }
            case 28: {
                return Primitives.readIntArray(in);
            }
            case 29: {
                return Primitives.readLongArray(in);
            }
            case 30: {
                return Primitives.readShortArray(in);
            }
        }
        throw new IOException("Unknown primitive sub id: " + Integer.toHexString(subId));
    }

    private static byte[] readByteArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new byte[0];
            }
            case 41: {
                return Primitives.readFully(Primitives.mkByteArray(in.readUnsignedByte() + 1), in);
            }
            case 42: {
                return Primitives.readFully(Primitives.mkByteArray(in.readUnsignedShort() + 257), in);
            }
            case 43: {
                return Primitives.readFully(new byte[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static byte[] mkByteArray(int len) {
        return new byte[len];
    }

    private static byte[] readFully(byte[] arr, BytesObjectInput in) throws EOFException {
        in.readFully(arr);
        return arr;
    }

    private static boolean[] readBooleanArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new boolean[0];
            }
            case 41: {
                return Primitives.readBooleans(Primitives.mkBooleanArray(in.readUnsignedByte() + 1), in);
            }
            case 42: {
                return Primitives.readBooleans(Primitives.mkBooleanArray(in.readUnsignedShort() + 257), in);
            }
            case 43: {
                return Primitives.readBooleans(new boolean[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static boolean[] mkBooleanArray(int len) {
        return new boolean[len];
    }

    private static boolean[] readBooleans(boolean[] arr, BytesObjectInput in) throws EOFException {
        byte v;
        int len = arr.length;
        int bc = len & 0xFFFFFFF8;
        int i = 0;
        while (i < bc) {
            v = in.readByte();
            arr[i++] = (v & 1) != 0;
            arr[i++] = (v & 2) != 0;
            arr[i++] = (v & 4) != 0;
            arr[i++] = (v & 8) != 0;
            arr[i++] = (v & 0x10) != 0;
            arr[i++] = (v & 0x20) != 0;
            arr[i++] = (v & 0x40) != 0;
            arr[i++] = (v & 0x80) != 0;
        }
        if (bc < len) {
            v = in.readByte();
            switch (len & 7) {
                case 7: {
                    arr[bc + 6] = (v & 0x40) != 0;
                }
                case 6: {
                    arr[bc + 5] = (v & 0x20) != 0;
                }
                case 5: {
                    arr[bc + 4] = (v & 0x10) != 0;
                }
                case 4: {
                    arr[bc + 3] = (v & 8) != 0;
                }
                case 3: {
                    arr[bc + 2] = (v & 4) != 0;
                }
                case 2: {
                    arr[bc + 1] = (v & 2) != 0;
                }
                case 1: {
                    arr[bc] = (v & 1) != 0;
                }
            }
        }
        return arr;
    }

    private static char[] readCharArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new char[0];
            }
            case 41: {
                return Primitives.readChars(Primitives.mkCharArray(in.readUnsignedByte() + 1), in);
            }
            case 42: {
                return Primitives.readChars(Primitives.mkCharArray(in.readUnsignedShort() + 257), in);
            }
            case 43: {
                return Primitives.readChars(new char[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static char[] mkCharArray(int len) {
        return new char[len];
    }

    private static char[] readChars(char[] arr, BytesObjectInput in) throws EOFException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readChar();
        }
        return arr;
    }

    private static double[] readDoubleArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new double[0];
            }
            case 41: {
                return Primitives.readDoubles(new double[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readDoubles(new double[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readDoubles(new double[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static double[] readDoubles(double[] arr, BytesObjectInput in) throws EOFException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readDouble();
        }
        return arr;
    }

    private static float[] readFloatArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new float[0];
            }
            case 41: {
                return Primitives.readFloats(new float[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readFloats(new float[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readFloats(new float[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static float[] readFloats(float[] arr, BytesObjectInput in) throws EOFException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readFloat();
        }
        return arr;
    }

    private static int[] readIntArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new int[0];
            }
            case 41: {
                return Primitives.readInts(new int[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readInts(new int[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readInts(new int[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static int[] readInts(int[] arr, BytesObjectInput in) throws EOFException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readInt();
        }
        return arr;
    }

    private static long[] readLongArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new long[0];
            }
            case 41: {
                return Primitives.readLongs(new long[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readLongs(new long[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readLongs(new long[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static long[] readLongs(long[] arr, BytesObjectInput in) throws EOFException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readLong();
        }
        return arr;
    }

    private static short[] readShortArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new short[0];
            }
            case 41: {
                return Primitives.readShorts(new short[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readShorts(new short[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readShorts(new short[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static short[] readShorts(short[] arr, BytesObjectInput in) throws EOFException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readShort();
        }
        return arr;
    }
}

