/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.file.SingleFileStoreReader;
import org.infinispan.tools.store.migrator.file.SoftIndexFileStoreIterator;
import org.infinispan.tools.store.migrator.jdbc.JdbcStoreReader;
import org.infinispan.tools.store.migrator.rocksdb.RocksDBReader;

class StoreIteratorFactory {
    StoreIteratorFactory() {
    }

    static StoreIterator get(Properties properties) {
        StoreProperties props = new StoreProperties(Element.SOURCE, properties);
        switch (props.storeType()) {
            case JDBC_BINARY: 
            case JDBC_MIXED: 
            case JDBC_STRING: {
                return new JdbcStoreReader(props);
            }
            case LEVELDB: 
            case ROCKSDB: {
                return new RocksDBReader(props);
            }
            case SINGLE_FILE_STORE: {
                return new SingleFileStoreReader(props);
            }
            case SOFT_INDEX_FILE_STORE: {
                return new SoftIndexFileStoreIterator(props);
            }
        }
        return null;
    }
}

