/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.io.InputStream;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.tools.store.migrator.jdbc.AbstractStringJdbcIterator;
import org.infinispan.util.KeyValuePair;

class StringJdbcIterator
extends AbstractStringJdbcIterator {
    StringJdbcIterator(ConnectionFactory connectionFactory, TableManager tableManager, Marshaller marshaller, TwoWayKey2StringMapper key2StringMapper) {
        super(connectionFactory, tableManager, marshaller, key2StringMapper);
    }

    @Override
    MarshallableEntry readMarshalledEntry(Object key, InputStream is) {
        KeyValuePair icv = (KeyValuePair)this.unmarshall(is);
        ByteBuffer buf = (ByteBuffer)icv.getKey();
        try {
            Object value = this.marshaller.objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
            return this.entryFactory.create(key, value);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

