/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.tools.store.migrator.jdbc.AbstractJdbcEntryIterator;

class BinaryJdbcIterator
extends AbstractJdbcEntryIterator {
    private Iterator<MarshallableEntry> iterator = Collections.emptyIterator();

    BinaryJdbcIterator(ConnectionFactory connectionFactory, TableManager tableManager, Marshaller marshaller) {
        super(connectionFactory, tableManager, marshaller);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() || this.rowIndex < this.numberOfRows;
    }

    @Override
    public MarshallableEntry next() {
        if (!this.iterator.hasNext()) {
            this.iterator = this.getNextBucketIterator();
        }
        ++this.rowIndex;
        return this.iterator.next();
    }

    private Iterator<MarshallableEntry> getNextBucketIterator() {
        try {
            if (this.rs.next()) {
                InputStream inputStream = this.rs.getBinaryStream(1);
                Map<Object, MarshallableEntry> bucketEntries = this.unmarshallBucketEntries(inputStream);
                this.numberOfRows += bucketEntries.size() - 1;
                return bucketEntries.values().iterator();
            }
            this.close();
            throw new NoSuchElementException();
        }
        catch (SQLException e) {
            throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
        }
    }

    private Map<Object, MarshallableEntry> unmarshallBucketEntries(InputStream inputStream) {
        try {
            return (Map)((StreamingMarshaller)this.marshaller).objectFromInputStream(inputStream);
        }
        catch (IOException e) {
            throw new PersistenceException("I/O error while unmarshalling from stream", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

