/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing.skip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;

public class StringLogAppender
extends AbstractAppender
implements Iterable<String> {
    private final String category;
    private final Level level;
    private final List<String> logs;
    private final Predicate<Thread> threadFilter;

    public StringLogAppender(String category, Level level, Predicate<Thread> threadFilter, Layout<?> layout) {
        super(StringLogAppender.class.getName(), null, layout, true, Property.EMPTY_ARRAY);
        this.category = category;
        this.level = level;
        this.logs = Collections.synchronizedList(new ArrayList());
        this.threadFilter = threadFilter;
    }

    public void install() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        this.start();
        config.addAppender((Appender)this);
        AppenderRef ref = AppenderRef.createAppenderRef((String)this.getName(), (Level)this.level, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.newBuilder().withAdditivity(true).withLevel(this.level).withLoggerName(this.category).withRefs(refs).withConfig(config).build();
        loggerConfig.addAppender((Appender)this, null, null);
        config.addLogger(this.category, loggerConfig);
        loggerContext.updateLoggers();
    }

    public void uninstall() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        loggerContext.getConfiguration().removeLogger(this.category);
        loggerContext.updateLoggers();
    }

    public void append(LogEvent event) {
        if (this.threadFilter.test(Thread.currentThread())) {
            this.logs.add((String)((Object)this.getLayout().toSerializable(event)));
        }
    }

    public int size() {
        return this.logs.size();
    }

    public String get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must not be negative.");
        }
        int size = this.logs.size();
        if (index >= size) {
            throw new IllegalArgumentException("Index " + index + " is out of bounds. " + (String)(size == 0 ? "No logs recorded yet." : "Accepted values are: [0 .. " + (size - 1) + "]"));
        }
        return this.logs.get(index);
    }

    @Override
    public Iterator<String> iterator() {
        return this.logs.iterator();
    }
}

