/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing.security;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public class TestCertificates {
    public static final String BASE_DN = "CN=%s,OU=Infinispan,O=JBoss,L=Red Hat";
    public static final char[] KEY_PASSWORD = "secret".toCharArray();
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String KEYSTORE_TYPE = KeyStore.getDefaultType();
    public static final String EXTENSION = ".pfx";
    private static final AtomicLong CERT_SERIAL = new AtomicLong(1L);

    public static String certificate(String name) {
        return TestCertificates.baseDir().resolve(name + EXTENSION).toString();
    }

    public static String pem(String name) {
        return TestCertificates.baseDir().resolve(name + ".pem").toString();
    }

    private static void createKeyStores() {
        try {
            X500Principal CA_DN = TestCertificates.dn("CA");
            SelfSignedX509CertificateAndSigningKey ca = TestCertificates.createSelfSignedCertificate(CA_DN, "ca");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            KeyStore trustStore = KeyStore.getInstance(KEYSTORE_TYPE);
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", ca.getSelfSignedCertificate());
            TestCertificates.createSignedCertificate(ca, "server", trustStore, keyPairGenerator);
            TestCertificates.createSignedCertificate(ca, "client", trustStore, keyPairGenerator);
            TestCertificates.createSignedCertificate(ca, "sni", trustStore, keyPairGenerator);
            try (OutputStream os = Files.newOutputStream(TestCertificates.getCertificateFile("trust.pfx"), new OpenOption[0]);){
                trustStore.store(os, KEY_PASSWORD);
            }
            TestCertificates.createSelfSignedCertificate(CA_DN, "untrusted");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Path baseDir() {
        return Paths.get(System.getProperty("user.dir"), "target", "test-classes");
    }

    private static X500Principal dn(String cn) {
        return new X500Principal(String.format(BASE_DN, cn));
    }

    private static Path getCertificateFile(String name) {
        return TestCertificates.baseDir().resolve(name);
    }

    private static SelfSignedX509CertificateAndSigningKey createSelfSignedCertificate(X500Principal dn, String name) {
        SelfSignedX509CertificateAndSigningKey certificate = SelfSignedX509CertificateAndSigningKey.builder().setDn(dn).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setKeyAlgorithmName(KEY_ALGORITHM).addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        X509Certificate issuerCertificate = certificate.getSelfSignedCertificate();
        TestCertificates.writeKeyStore(TestCertificates.getCertificateFile(name + EXTENSION), ks -> {
            try {
                ks.setCertificateEntry(name, issuerCertificate);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
        try (BufferedWriter w = Files.newBufferedWriter(TestCertificates.baseDir().resolve(name + ".pem"), new OpenOption[0]);){
            w.write("-----BEGIN PRIVATE KEY-----\n");
            w.write(Base64.getEncoder().encodeToString(certificate.getSigningKey().getEncoded()));
            w.write("\n-----END PRIVATE KEY-----\n");
            w.write("-----BEGIN CERTIFICATE-----\n");
            w.write(Base64.getEncoder().encodeToString(issuerCertificate.getEncoded()));
            w.write("\n-----END CERTIFICATE-----\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return certificate;
    }

    private static void createSignedCertificate(SelfSignedX509CertificateAndSigningKey ca, String name, KeyStore trustStore, KeyPairGenerator keyPairGenerator) throws CertificateException {
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate caCertificate = ca.getSelfSignedCertificate();
        X500Principal issuerDN = caCertificate.getIssuerX500Principal();
        X509Certificate certificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(TestCertificates.dn(name)).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setSigningKey(ca.getSigningKey()).setPublicKey(keyPair.getPublic()).setSerialNumber(BigInteger.valueOf(CERT_SERIAL.getAndIncrement())).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).addExtension((X509CertificateExtension)new SubjectAlternativeNamesExtension(false, List.of(new GeneralName.DNSName(name), new GeneralName.DNSName("localhost")))).build();
        try {
            trustStore.setCertificateEntry(name, certificate);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        TestCertificates.writeKeyStore(TestCertificates.getCertificateFile(name + EXTENSION), ks -> {
            try {
                ks.setCertificateEntry("ca", caCertificate);
                ks.setKeyEntry(name, keyPair.getPrivate(), KEY_PASSWORD, new X509Certificate[]{certificate, caCertificate});
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void writeKeyStore(Path file, Consumer<KeyStore> consumer) {
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            consumer.accept(keyStore);
            keyStore.store(os, KEY_PASSWORD);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        TestCertificates.createKeyStores();
    }
}

