/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing.log4j;

import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="ThreadNameFilter", category="Core", elementType="filter", printObject=true)
public final class ThreadNameFilter
extends AbstractFilter {
    private final Level level;
    private final Pattern includePattern;

    private ThreadNameFilter(Level level, String includeRegex) {
        this.level = level == null ? Level.DEBUG : level;
        this.includePattern = Pattern.compile(includeRegex == null ? ".*" : includeRegex);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter(level, Thread.currentThread().getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter(level, Thread.currentThread().getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(level, Thread.currentThread().getName());
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getLevel(), event.getThreadName());
    }

    private Filter.Result filter(Level level, String threadName) {
        if (level.isMoreSpecificThan(this.level)) {
            return Filter.Result.NEUTRAL;
        }
        if (this.includePattern == null || this.includePattern.matcher(threadName).find()) {
            return Filter.Result.NEUTRAL;
        }
        return Filter.Result.DENY;
    }

    public String toString() {
        return "ThreadNameFilter{level=" + String.valueOf(this.level) + ", include=" + this.includePattern.pattern() + "}";
    }

    @PluginFactory
    public static ThreadNameFilter createFilter(@PluginAttribute(value="level") Level level, @PluginAttribute(value="include") String include) {
        return new ThreadNameFilter(level, include);
    }
}

