/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing.log4j;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="BoundedPurgePolicy", category="Core", printObject=true)
public class BoundedPurgePolicy
extends AbstractLifeCycle
implements PurgePolicy {
    public static final String VALUE = "";
    private final int maxSize;
    private final Map<String, String> appendersUsage;
    private final String excludePrefix;
    private RoutingAppender routingAppender;

    public BoundedPurgePolicy(int maxSize, String excludePrefix) {
        this.maxSize = maxSize;
        this.appendersUsage = new LinkedHashMap<String, String>((int)((float)maxSize * 0.75f), 0.75f, true);
        this.excludePrefix = excludePrefix;
    }

    public void initialize(RoutingAppender routingAppender) {
        this.routingAppender = routingAppender;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopped();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        BoundedPurgePolicy boundedPurgePolicy = this;
        synchronized (boundedPurgePolicy) {
            Iterator<String> iterator = this.appendersUsage.keySet().iterator();
            while (this.appendersUsage.size() > this.maxSize) {
                String key = iterator.next();
                LOGGER.debug("Removing appender " + key);
                iterator.remove();
                ((AppenderControl)this.routingAppender.getAppenders().get(key)).getAppender().stop();
                this.routingAppender.deleteAppender(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String key, LogEvent event) {
        if (key != null && key.startsWith(this.excludePrefix)) {
            return;
        }
        BoundedPurgePolicy boundedPurgePolicy = this;
        synchronized (boundedPurgePolicy) {
            String previous = this.appendersUsage.putIfAbsent(key, VALUE);
            if (previous == null) {
                this.purge();
            }
        }
    }

    @PluginFactory
    public static PurgePolicy createPurgePolicy(@PluginAttribute(value="size") int size, @PluginAttribute(value="excludePrefix", defaultString="${") String excludePrefix) {
        return new BoundedPurgePolicy(size, excludePrefix);
    }

    public String toString() {
        return "size=" + this.maxSize;
    }
}

