/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.ITestResult;

public class PolarionJUnitTest {
    final String name;
    final String clazz;
    final List<Throwable> failures = Collections.synchronizedList(new ArrayList());
    final AtomicInteger successes = new AtomicInteger();
    final AtomicLong elapsedTime = new AtomicLong();
    volatile Status status = Status.ERROR;

    public PolarionJUnitTest(String name, String clazz) {
        this(name, clazz, null);
    }

    public PolarionJUnitTest(String name, String clazz, Throwable t) {
        this.name = name;
        this.clazz = clazz;
        if (t != null) {
            this.failures.add(t);
            this.status = Status.FAILURE;
        }
    }

    void add(ITestResult tr) {
        switch (tr.getStatus()) {
            case 1: {
                this.status = this.failures.isEmpty() ? Status.SUCCESS : Status.FLAKY;
                this.successes.incrementAndGet();
                break;
            }
            case 2: {
                this.failures.add(tr.getThrowable());
                this.status = Status.FAILURE;
                break;
            }
            case 3: 
            case 4: {
                this.status = Status.SKIPPED;
                break;
            }
            default: {
                this.status = Status.ERROR;
            }
        }
        this.elapsedTime.addAndGet(tr.getEndMillis() - tr.getStartMillis());
    }

    long elapsedTime() {
        return this.elapsedTime.get();
    }

    int numberOfExecutions() {
        return this.successes.get() + this.failures.size();
    }

    public static enum Status {
        SUCCESS,
        FLAKY,
        FAILURE,
        ERROR,
        SKIPPED;

    }
}

