/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing.junit;

import java.util.concurrent.TimeUnit;
import org.infinispan.testing.TestSuiteProgress;
import org.infinispan.testing.Testing;
import org.infinispan.testing.ThreadLeakChecker;
import org.junit.Test;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitTestListener
extends RunListener {
    private final ThreadLocal<Boolean> currentTestIsSuccessful = new ThreadLocal();
    private final TestSuiteProgress progressLogger = new TestSuiteProgress();
    private String currentTestRunName;

    private static long computeTimeoutForMethod(FrameworkMethod method) {
        Test testAnnotation = (Test)method.getAnnotation(Test.class);
        if (testAnnotation != null && testAnnotation.timeout() > 0L) {
            return 0L;
        }
        return Testing.MAX_TEST_SECONDS * 1000L;
    }

    public void testStarted(Description description) throws Exception {
        String testName = this.testName(description);
        this.progressLogger.testStarted(testName);
        this.currentTestIsSuccessful.set(true);
    }

    public void testFinished(Description description) throws Exception {
        if (this.currentTestIsSuccessful.get().booleanValue()) {
            this.progressLogger.testSucceeded(this.testName(description));
        }
    }

    public void testFailure(Failure failure) {
        this.currentTestIsSuccessful.set(false);
        this.progressLogger.testFailed(this.testName(failure.getDescription()), failure.getException());
    }

    public void testIgnored(Description description) {
        this.currentTestIsSuccessful.set(false);
        this.progressLogger.testIgnored(this.testName(description));
    }

    public void testAssumptionFailure(Failure failure) {
        this.currentTestIsSuccessful.set(false);
        this.progressLogger.testAssumptionFailed(this.testName(failure.getDescription()), failure.getException());
    }

    private String testName(Description description) {
        String className = description.isSuite() ? "suite" : description.getTestClass().getSimpleName();
        return className + "." + description.getMethodName();
    }

    public void testRunStarted(Description description) {
        TestSuiteProgress.printTestJDKInformation();
        ThreadLeakChecker.saveInitialThreads();
        this.currentTestRunName = description.getDisplayName();
    }

    public void testRunFinished(Result result) {
        try {
            ThreadLeakChecker.checkForLeaks(this.currentTestRunName);
        }
        catch (Throwable e) {
            this.progressLogger.configurationFailed("[ERROR]", e);
            throw e;
        }
    }

    public static class Runner
    extends BlockJUnit4ClassRunner {
        public Runner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            notifier.addListener((RunListener)new JUnitTestListener());
            Description description = this.describeChild(method);
            if (this.isIgnored(method)) {
                notifier.fireTestIgnored(description);
            } else {
                Statement statement = this.methodBlock(method);
                long timeoutMillis = JUnitTestListener.computeTimeoutForMethod(method);
                if (timeoutMillis > 0L) {
                    statement = FailOnTimeout.builder().withTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build(statement);
                }
                this.runLeaf(statement, description, notifier);
            }
        }
    }
}

