/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.testing.Ansi;
import org.jboss.logging.Logger;

public class TestSuiteProgress {
    private static final Logger log = Logger.getLogger(TestSuiteProgress.class);
    private final AtomicInteger failed = new AtomicInteger(0);
    private final AtomicInteger succeeded = new AtomicInteger(0);
    private final AtomicInteger skipped = new AtomicInteger(0);
    private final PrintStream out = System.out;

    public void testStarted(String name) {
        String message = "Test starting: " + name;
        this.progress(message);
        log.info((Object)message);
    }

    public void testSucceeded(String name) {
        this.succeeded.incrementAndGet();
        String message = "Test succeeded: " + name;
        this.progress("\u001b[32m", message);
        log.info((Object)message);
    }

    public void testFailed(String name, Throwable exception) {
        this.failed.incrementAndGet();
        String message = "Test failed: " + name;
        this.progress("\u001b[31m", message, exception);
        log.error((Object)message, exception);
    }

    public void testIgnored(String name) {
        this.skipped.incrementAndGet();
        String message = "Test ignored: " + name;
        this.progress("\u001b[33m", message);
        log.info((Object)message);
    }

    public void testAssumptionFailed(String name, Throwable exception) {
        this.skipped.incrementAndGet();
        String message = "Test assumption failed: " + name;
        this.progress("\u001b[33m", message, exception);
        log.info((Object)message, exception);
    }

    public void configurationStarted(String name) {
        log.debug((Object)("Test configuration started: " + name));
    }

    public void configurationFinished(String name) {
        log.debug((Object)("Test configuration finished: " + name));
    }

    public void configurationFailed(String name, Throwable exception) {
        this.failed.incrementAndGet();
        String message = "Test configuration failed: " + name;
        this.progress("\u001b[31m", message, exception);
        log.error((Object)message, exception);
    }

    public static void fakeTestFailure(String name, Throwable exception) {
        String message = "Test failed: " + name;
        System.out.printf("[TestSuiteProgress] %s%n", message);
        log.error((Object)message, exception);
    }

    public static void printTestJDKInformation() {
        String message = "Running tests with JDK " + System.getProperty("java.version");
        System.out.println(message);
        log.info((Object)message);
    }

    private void progress(CharSequence message) {
        this.progress(null, message, null);
    }

    private void progress(String color, CharSequence message) {
        this.progress(color, message, null);
    }

    private synchronized void progress(String color, CharSequence message, Throwable t) {
        String actualColor = "";
        String reset = "";
        String okColor = "";
        String koColor = "";
        String skipColor = "";
        if (Ansi.useColor && color != null) {
            actualColor = color;
            reset = "\u001b[0m";
            if (this.succeeded.get() > 0) {
                okColor = "\u001b[32m";
            }
            if (this.failed.get() > 0) {
                okColor = "\u001b[31m";
            }
            if (this.skipped.get() > 0) {
                skipColor = "\u001b[36m";
            }
        }
        this.out.println(String.format("[%sOK: %5s%s, %sKO: %5s%s, %sSKIP: %5s%s] %s%s%s", okColor, this.succeeded.get(), reset, koColor, this.failed.get(), reset, skipColor, this.skipped.get(), reset, actualColor, message, reset));
        if (t != null) {
            t.printStackTrace(this.out);
        }
    }
}

