/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.testing;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.infinispan.testing.ExceptionRunnable;
import org.infinispan.testing.ThrowableSupplier;

public class Exceptions {
    public static void assertException(Class<? extends Throwable> exceptionClass, Throwable t) {
        if (t == null) {
            throw new AssertionError("Should have thrown an " + exceptionClass.getName(), null);
        }
        if (t.getClass() != exceptionClass) {
            throw new AssertionError("Wrong exception thrown: expected:<" + exceptionClass.getName() + ">, actual:<" + t.getClass().getName() + ">", t);
        }
    }

    public static void assertException(Class<? extends Throwable> exceptionClass, String messageRegex, Throwable t) {
        Exceptions.assertException(exceptionClass, t);
        Pattern pattern = Pattern.compile(messageRegex);
        if (!pattern.matcher(t.getMessage()).matches()) {
            throw new AssertionError("Wrong exception message: expected:<" + messageRegex + ">, actual:<" + t.getMessage() + ">", t);
        }
    }

    public static void assertExceptionNonStrict(Class<? extends Throwable> exceptionClass, Throwable t) {
        if (t == null) {
            throw new AssertionError("Should have thrown an " + String.valueOf(exceptionClass), null);
        }
        if (!exceptionClass.isInstance(t)) {
            throw new AssertionError("Wrong exception thrown: expected:<" + String.valueOf(exceptionClass) + ">, actual:<" + String.valueOf(t.getClass()) + ">", t);
        }
    }

    public static void assertException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, Throwable t) {
        Exceptions.assertException(wrapperExceptionClass, t);
        Exceptions.assertException(exceptionClass, t.getCause());
    }

    public static void assertException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, Throwable t) {
        Exceptions.assertException(wrapperExceptionClass, t);
        Exceptions.assertException(exceptionClass, messageRegex, t.getCause());
    }

    public static void assertException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, Throwable t) {
        Exceptions.assertException(wrapperExceptionClass2, t);
        Exceptions.assertException(wrapperExceptionClass, t.getCause());
        Exceptions.assertException(exceptionClass, t.getCause().getCause());
    }

    public static void assertException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, Throwable t) {
        Exceptions.assertException(wrapperExceptionClass2, t);
        Exceptions.assertException(wrapperExceptionClass, t.getCause());
        Exceptions.assertException(exceptionClass, messageRegex, t.getCause().getCause());
    }

    public static void assertException(Class<? extends Throwable> wrapperExceptionClass3, Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, Throwable t) {
        Exceptions.assertException(wrapperExceptionClass3, t);
        Exceptions.assertException(wrapperExceptionClass2, t.getCause());
        Exceptions.assertException(wrapperExceptionClass, t.getCause().getCause());
        Exceptions.assertException(exceptionClass, t.getCause().getCause().getCause());
    }

    public static void assertRootCause(Class<? extends Throwable> throwableClass, Throwable t) {
        Throwable rootCause = Exceptions.getRootCause(t);
        Exceptions.assertException(throwableClass, rootCause);
    }

    public static void expectException(Class<? extends Throwable> exceptionClass, String messageRegex, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertException(exceptionClass, messageRegex, t);
    }

    public static void expectException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertException(wrapperExceptionClass, exceptionClass, messageRegex, t);
    }

    public static void expectException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass1, Class<? extends Throwable> exceptionClass, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertException(wrapperExceptionClass2, wrapperExceptionClass1, exceptionClass, t);
    }

    public static void expectException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass1, Class<? extends Throwable> exceptionClass, String regex, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertException(wrapperExceptionClass2, wrapperExceptionClass1, exceptionClass, regex, t);
    }

    public static void expectException(Class<? extends Throwable> exceptionClass, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertException(exceptionClass, t);
    }

    public static void expectException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertException(wrapperExceptionClass, t);
        Exceptions.assertException(exceptionClass, t.getCause());
    }

    @SafeVarargs
    public static void expectException(String regex, ExceptionRunnable runnable, Class<? extends Throwable> ... wrapperExceptionClass) {
        Throwable t = Exceptions.extractException(runnable);
        for (int i = 0; i < wrapperExceptionClass.length - 1; ++i) {
            Class<? extends Throwable> exceptionClass = wrapperExceptionClass[i];
            Exceptions.assertException(exceptionClass, t);
            t = t.getCause();
        }
        Exceptions.assertException(wrapperExceptionClass[wrapperExceptionClass.length - 1], regex, t);
    }

    public static void expectRootCause(Class<? extends Throwable> exceptionClass, ExceptionRunnable runnable) {
        Throwable t = Exceptions.getRootCause(Exceptions.extractException(runnable));
        Exceptions.assertException(exceptionClass, t);
    }

    public static void expectExceptionNonStrict(Class<? extends Throwable> e, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertExceptionNonStrict(e, t);
    }

    public static void expectExceptionNonStrict(Class<? extends Throwable> we1, Class<? extends Throwable> e, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertExceptionNonStrict(we1, t);
        Exceptions.assertExceptionNonStrict(e, t.getCause());
    }

    public static void expectExceptionNonStrict(Class<? extends Throwable> we2, Class<? extends Throwable> we1, Class<? extends Throwable> e, ExceptionRunnable runnable) {
        Throwable t = Exceptions.extractException(runnable);
        Exceptions.assertExceptionNonStrict(we2, t);
        Exceptions.assertExceptionNonStrict(we1, t.getCause());
        Exceptions.assertExceptionNonStrict(e, t.getCause().getCause());
    }

    public static void expectExecutionException(Class<? extends Throwable> exceptionClass, String messageRegex, Future<?> future) {
        Exceptions.expectExecutionException(exceptionClass, messageRegex, future, 10L, TimeUnit.SECONDS);
    }

    public static void expectExecutionException(Class<? extends Throwable> exceptionClass, String messageRegex, Future<?> future, long timeout, TimeUnit unit) {
        Throwable t = Exceptions.extractException(() -> future.get(timeout, unit));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(exceptionClass, messageRegex, t.getCause());
    }

    public static void expectExecutionException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, Future<?> future) {
        Throwable t = Exceptions.extractException(() -> future.get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass, t.getCause());
        Exceptions.assertException(exceptionClass, messageRegex, t.getCause().getCause());
    }

    public static void expectExecutionException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, Future<?> future) {
        Throwable t = Exceptions.extractException(() -> future.get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass2, t.getCause());
        Exceptions.assertException(wrapperExceptionClass, exceptionClass, messageRegex, t.getCause().getCause());
    }

    public static void expectExecutionException(Class<? extends Throwable> exceptionClass, Future<?> future) {
        Throwable t = Exceptions.extractException(() -> future.get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(exceptionClass, t.getCause());
    }

    public static void expectExecutionException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, Future<?> future) {
        Throwable t = Exceptions.extractException(() -> future.get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass, t.getCause());
        Exceptions.assertException(exceptionClass, t.getCause().getCause());
    }

    public static void expectExecutionException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, Future<?> future) {
        Throwable t = Exceptions.extractException(() -> future.get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass2, t.getCause());
        Exceptions.assertException(wrapperExceptionClass, exceptionClass, t.getCause().getCause());
    }

    public static void expectCompletionException(Class<? extends Throwable> exceptionClass, String messageRegex, CompletionStage<?> stage) {
        Exceptions.expectCompletionException(exceptionClass, messageRegex, stage, 10L, TimeUnit.SECONDS);
    }

    public static void expectCompletionException(Class<? extends Throwable> exceptionClass, String messageRegex, CompletionStage<?> stage, long timeout, TimeUnit unit) {
        Throwable t = Exceptions.extractException(() -> stage.toCompletableFuture().get(timeout, unit));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(exceptionClass, messageRegex, t.getCause());
    }

    public static void expectCompletionException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, CompletionStage<?> stage) {
        Throwable t = Exceptions.extractException(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass, t.getCause());
        Exceptions.assertException(exceptionClass, messageRegex, t.getCause().getCause());
    }

    public static void expectCompletionException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, String messageRegex, CompletionStage<?> stage) {
        Throwable t = Exceptions.extractException(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass2, t.getCause());
        Exceptions.assertException(wrapperExceptionClass, exceptionClass, messageRegex, t.getCause().getCause());
    }

    public static void expectCompletionException(Class<? extends Throwable> exceptionClass, CompletionStage<?> stage) {
        Throwable t = Exceptions.extractException(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(exceptionClass, t.getCause());
    }

    public static void expectCompletionException(Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, CompletionStage<?> stage) {
        Throwable t = Exceptions.extractException(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass, t.getCause());
        Exceptions.assertException(exceptionClass, t.getCause().getCause());
    }

    public static void expectCompletionException(Class<? extends Throwable> wrapperExceptionClass2, Class<? extends Throwable> wrapperExceptionClass, Class<? extends Throwable> exceptionClass, CompletionStage<?> stage) {
        Throwable t = Exceptions.extractException(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
        Exceptions.assertException(ExecutionException.class, t);
        Exceptions.assertException(wrapperExceptionClass2, t.getCause());
        Exceptions.assertException(wrapperExceptionClass, exceptionClass, t.getCause().getCause());
    }

    public static Throwable extractException(ExceptionRunnable runnable) {
        Throwable exception = null;
        try {
            runnable.run();
        }
        catch (Throwable t) {
            exception = t;
        }
        return exception;
    }

    public static Throwable getRootCause(Throwable re) {
        if (re == null) {
            return null;
        }
        Throwable cause = re.getCause();
        if (cause != null) {
            return Exceptions.getRootCause(cause);
        }
        return re;
    }

    public static void unchecked(ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T unchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T uncheckedThrowable(ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

