/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.spring.remote.ConfigurationPropertiesOverrides;
import org.springframework.core.io.Resource;

public abstract class AbstractRemoteCacheManagerFactory {
    protected static final Log logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String SPRING_JAVA_SERIAL_ALLOWLIST = "java.util.HashMap,java.time.*,org.springframework.*,org.infinispan.spring.remote.*";
    protected boolean startAutomatically = true;
    private Properties configurationProperties;
    private Resource configurationPropertiesFileLocation;
    private final ConfigurationPropertiesOverrides configurationPropertiesOverrides = new ConfigurationPropertiesOverrides();

    protected void assertCorrectlyConfigured() throws IllegalStateException {
        if (this.configurationProperties != null && this.configurationPropertiesFileLocation != null) {
            throw new IllegalStateException("You may only use either \"configurationProperties\" or \"configurationPropertiesFileLocation\" to configure the RemoteCacheManager, not both.");
        }
        if (this.configurationProperties != null && !this.configurationPropertiesOverrides.isEmpty()) {
            throw new IllegalStateException("You may only use either \"configurationProperties\" or setters on this FactoryBean to configure the RemoteCacheManager, not both.");
        }
    }

    protected Properties configurationProperties() throws IOException {
        Properties answer;
        if (this.configurationProperties != null) {
            answer = this.configurationPropertiesOverrides.override(this.configurationProperties);
            logger.debug((Object)("Using user-defined properties [" + String.valueOf(this.configurationProperties) + "] for configuring RemoteCacheManager"));
        } else if (this.configurationPropertiesFileLocation != null) {
            answer = this.loadPropertiesFromFile(this.configurationPropertiesFileLocation);
            logger.debug((Object)("Loading properties from file [" + String.valueOf(this.configurationProperties) + "] for configuring RemoteCacheManager"));
        } else if (!this.configurationPropertiesOverrides.isEmpty()) {
            answer = this.configurationPropertiesOverrides.override(new Properties());
            logger.debug((Object)("Using explicitly set configuration settings [" + String.valueOf(answer) + "] for configuring RemoteCacheManager"));
        } else {
            logger.debug((Object)"No configuration properties. RemoteCacheManager will use default configuration.");
            RemoteCacheManager remoteCacheManager = new RemoteCacheManager(false);
            try {
                answer = remoteCacheManager.getConfiguration().properties();
            }
            finally {
                remoteCacheManager.stop();
            }
        }
        this.initializeMarshallingProperties(answer);
        return answer;
    }

    private void initializeMarshallingProperties(Properties properties) {
        if (!this.configurationPropertiesOverrides.containsProperty("infinispan.client.hotrod.marshaller")) {
            String marshaller = JavaSerializationMarshaller.class.getName();
            String configuredMarshaller = properties.getProperty("infinispan.client.hotrod.marshaller");
            if (configuredMarshaller != null && configuredMarshaller.equals("org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller") && Util.getJBossMarshaller((ClassLoader)Thread.currentThread().getContextClassLoader(), null) != null) {
                marshaller = configuredMarshaller;
            }
            properties.setProperty("infinispan.client.hotrod.marshaller", marshaller);
        }
        if (!this.configurationPropertiesOverrides.containsProperty("infinispan.client.hotrod.java_serial_whitelist") && !this.configurationPropertiesOverrides.containsProperty("infinispan.client.hotrod.java_serial_allowlist")) {
            String userWhiteList;
            LinkedHashSet userRegexSet = new LinkedHashSet();
            Collections.addAll(userRegexSet, SPRING_JAVA_SERIAL_ALLOWLIST.split(","));
            String userAllowList = properties.getProperty("infinispan.client.hotrod.java_serial_allowlist");
            if (userAllowList != null && !userAllowList.isEmpty()) {
                Collections.addAll(userRegexSet, userAllowList.split(","));
            }
            if ((userWhiteList = properties.getProperty("infinispan.client.hotrod.java_serial_whitelist")) != null && !userWhiteList.isEmpty()) {
                Collections.addAll(userRegexSet, userWhiteList.split(","));
            }
            String allowList = String.join((CharSequence)",", userRegexSet);
            properties.setProperty("infinispan.client.hotrod.java_serial_allowlist", allowList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(Resource propertiesFileLocation) throws IOException {
        InputStream propsStream = null;
        try {
            propsStream = propertiesFileLocation.getInputStream();
            Properties answer = new Properties();
            answer.load(propsStream);
            Properties properties = answer;
            return properties;
        }
        finally {
            if (propsStream != null) {
                try {
                    propsStream.close();
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to close InputStream used to load configuration properties: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setConfigurationPropertiesFileLocation(Resource configurationPropertiesFileLocation) {
        this.configurationPropertiesFileLocation = configurationPropertiesFileLocation;
    }

    public void setStartAutomatically(boolean startAutomatically) {
        this.startAutomatically = startAutomatically;
    }

    public void setServerList(Collection<InetSocketAddress> serverList) {
        this.configurationPropertiesOverrides.setServerList(serverList);
    }

    public void setMarshaller(String marshaller) {
        this.configurationPropertiesOverrides.setMarshaller(marshaller);
    }

    public void setClassAllowList(String allowListRegex) {
        this.configurationPropertiesOverrides.setClassAllowList(allowListRegex);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public void setClassWhiteList(String allowListRegex) {
        this.setClassAllowList(allowListRegex);
    }

    public void setAsyncExecutorFactory(String asyncExecutorFactory) {
        this.configurationPropertiesOverrides.setAsyncExecutorFactory(asyncExecutorFactory);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.configurationPropertiesOverrides.setTcpNoDelay(tcpNoDelay);
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.configurationPropertiesOverrides.setTcpKeepAlive(tcpKeepAlive);
    }

    public void setRequestBalancingStrategy(String requestBalancingStrategy) {
        this.configurationPropertiesOverrides.setRequestBalancingStrategy(requestBalancingStrategy);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public void setKeySizeEstimate(int keySizeEstimate) {
        this.configurationPropertiesOverrides.setKeySizeEstimate(keySizeEstimate);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public void setValueSizeEstimate(int valueSizeEstimate) {
        this.configurationPropertiesOverrides.setValueSizeEstimate(valueSizeEstimate);
    }

    public void setForceReturnValues(boolean forceReturnValues) {
        this.configurationPropertiesOverrides.setForceReturnValues(forceReturnValues);
    }

    public void setReadTimeout(long readTimeout) {
        this.configurationPropertiesOverrides.setReadTimeout(readTimeout);
    }

    public void setWriteTimeout(long writeTimeout) {
        this.configurationPropertiesOverrides.setWriteTimeout(writeTimeout);
    }

    public void setNearCacheMode(String mode) {
        this.configurationPropertiesOverrides.setNearCacheMode(mode);
    }

    public void setNearCacheMaxEntries(int maxEntries) {
        this.configurationPropertiesOverrides.setNearCacheMaxEntries(maxEntries);
    }

    public void setNearCacheNamePattern(String pattern) {
        this.configurationPropertiesOverrides.setNearCacheNamePattern(pattern);
    }
}

