/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.support;

import java.lang.invoke.MethodHandles;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class InfinispanNamedEmbeddedCacheFactoryBean<K, V>
implements FactoryBean<Cache<K, V>>,
BeanNameAware,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private EmbeddedCacheManager infinispanEmbeddedCacheManager;
    private ConfigurationTemplateMode configurationTemplateMode = ConfigurationTemplateMode.NAMED;
    private String cacheName;
    private String beanName;
    private Cache<K, V> infinispanCache;
    private ConfigurationBuilder builder = null;

    public void afterPropertiesSet() throws Exception {
        if (this.infinispanEmbeddedCacheManager == null) {
            throw new IllegalStateException("No Infinispan EmbeddedCacheManager has been set");
        }
        logger.info((Object)"Initializing named Infinispan embedded cache ...");
        String effectiveCacheName = this.obtainEffectiveCacheName();
        this.infinispanCache = this.configureAndCreateNamedCache(effectiveCacheName);
        logger.info((Object)("New Infinispan embedded cache [" + String.valueOf(this.infinispanCache) + "] initialized"));
    }

    private Cache<K, V> configureAndCreateNamedCache(String cacheName) {
        switch (this.configurationTemplateMode.ordinal()) {
            case 0: {
                logger.debug((Object)"ConfigurationTemplateMode is NONE: using a fresh Configuration");
                if (this.infinispanEmbeddedCacheManager.getCacheNames().contains(cacheName)) {
                    throw new IllegalStateException("Cannot use ConfigurationTemplateMode NONE: a cache named [" + cacheName + "] has already been defined.");
                }
                this.builder = new ConfigurationBuilder();
                this.infinispanEmbeddedCacheManager.defineConfiguration(cacheName, this.builder.build());
                break;
            }
            case 3: {
                logger.debug((Object)("ConfigurationTemplateMode is NAMED: using a named Configuration [" + cacheName + "]"));
                break;
            }
            case 1: {
                logger.debug((Object)"ConfigurationTemplateMode is DEFAULT.");
                if (!this.infinispanEmbeddedCacheManager.getCacheNames().contains(cacheName)) break;
                throw new IllegalStateException("Cannot use ConfigurationTemplateMode DEFAULT: a cache named [" + cacheName + "] has already been defined.");
            }
            case 2: {
                logger.debug((Object)"ConfigurationTemplateMode is CUSTOM. Using the provided ConfigurationBuilder.");
                if (this.builder == null) {
                    throw new IllegalStateException("There has not been a ConfigurationBuilder provided. There has to be one provided for ConfigurationTemplateMode CUSTOM.");
                }
                this.infinispanEmbeddedCacheManager.defineConfiguration(cacheName, this.builder.build());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ConfigurationTemplateMode: " + String.valueOf((Object)this.configurationTemplateMode));
            }
        }
        return this.infinispanEmbeddedCacheManager.getCache(cacheName);
    }

    private String obtainEffectiveCacheName() {
        if (StringUtils.hasText((String)this.cacheName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using custom cache name [" + this.cacheName + "]"));
            }
            return this.cacheName;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using bean name [" + this.beanName + "] as cache name"));
        }
        return this.beanName;
    }

    public Cache<K, V> getObject() throws Exception {
        return this.infinispanCache;
    }

    public Class<? extends Cache> getObjectType() {
        return this.infinispanCache != null ? this.infinispanCache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void destroy() throws Exception {
        if (this.infinispanCache != null) {
            this.infinispanCache.stop();
        }
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setInfinispanEmbeddedCacheManager(EmbeddedCacheManager infinispanEmbeddedCacheManager) {
        this.infinispanEmbeddedCacheManager = infinispanEmbeddedCacheManager;
    }

    public void setConfigurationTemplateMode(String configurationTemplateMode) throws IllegalArgumentException {
        this.configurationTemplateMode = ConfigurationTemplateMode.valueOf(configurationTemplateMode);
    }

    public void addCustomConfiguration(ConfigurationBuilder builder) {
        this.builder = builder;
    }

    static enum ConfigurationTemplateMode {
        NONE,
        DEFAULT,
        CUSTOM,
        NAMED;

    }
}

