/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.provider.SpringCache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class SpringRemoteCacheManager
implements CacheManager {
    private final RemoteCacheManager nativeCacheManager;
    private volatile long readTimeout;
    private volatile long writeTimeout;

    public SpringRemoteCacheManager(RemoteCacheManager nativeCacheManager, long readTimeout, long writeTimeout) {
        Assert.notNull((Object)nativeCacheManager, (String)"A non-null instance of EmbeddedCacheManager needs to be supplied");
        this.nativeCacheManager = nativeCacheManager;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
    }

    public SpringRemoteCacheManager(RemoteCacheManager nativeCacheManager) {
        this(nativeCacheManager, 0L, 0L);
    }

    public SpringCache getCache(String name) {
        RemoteCache nativeCache = this.nativeCacheManager.getCache(name);
        return new SpringCache((BasicCache)nativeCache, this.readTimeout, this.writeTimeout);
    }

    public Collection<String> getCacheNames() {
        return this.nativeCacheManager.getCacheNames();
    }

    public RemoteCacheManager getNativeCacheManager() {
        return this.nativeCacheManager;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void start() {
        this.nativeCacheManager.start();
    }

    public void stop() {
        this.nativeCacheManager.stop();
    }
}

