/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class ConfigurationPropertiesOverrides {
    private final Properties overridingProperties = new Properties();

    public boolean isEmpty() {
        return this.overridingProperties.isEmpty();
    }

    public void setTransportFactory(String TransportFactory) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.transport_factory", TransportFactory);
    }

    public void setServerList(Collection<InetSocketAddress> serverList) {
        StringBuilder serverListStr = new StringBuilder();
        for (InetSocketAddress server : serverList) {
            serverListStr.append(server.getHostName()).append(":").append(server.getPort()).append(";");
        }
        serverListStr.deleteCharAt(serverListStr.length() - 1);
        this.overridingProperties.setProperty("infinispan.client.hotrod.server_list", serverListStr.toString());
    }

    public void setMarshaller(String marshaller) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.marshaller", marshaller);
    }

    public void setAsyncExecutorFactory(String asyncExecutorFactory) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.async_executor_factory", asyncExecutorFactory);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.tcp_no_delay", Boolean.toString(tcpNoDelay));
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.tcp_keep_alive", Boolean.toString(tcpKeepAlive));
    }

    @Deprecated
    public void setPingOnStartup(boolean pingOnStartup) {
    }

    public void setRequestBalancingStrategy(String requestBalancingStrategy) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.request_balancing_strategy", requestBalancingStrategy);
    }

    public void setKeySizeEstimate(int keySizeEstimate) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.key_size_estimate", Integer.toString(keySizeEstimate));
    }

    public void setValueSizeEstimate(int valueSizeEstimate) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.value_size_estimate", Integer.toString(valueSizeEstimate));
    }

    public void setForceReturnValues(boolean forceReturnValues) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.force_return_values", Boolean.toString(forceReturnValues));
    }

    public Properties override(Properties configurationPropertiesToOverride) {
        Properties answer = (Properties)Properties.class.cast(configurationPropertiesToOverride.clone());
        for (Map.Entry<Object, Object> prop : this.overridingProperties.entrySet()) {
            answer.setProperty((String)String.class.cast(prop.getKey()), (String)String.class.cast(prop.getValue()));
        }
        return answer;
    }
}

