/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.common.provider.SpringCache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class SpringEmbeddedCacheManager
implements CacheManager {
    private final EmbeddedCacheManager nativeCacheManager;
    private final ConcurrentMap<String, SpringCache> springCaches = new ConcurrentHashMap<String, SpringCache>();
    private final boolean reactive;

    public SpringEmbeddedCacheManager(EmbeddedCacheManager nativeCacheManager) {
        this(nativeCacheManager, false);
    }

    public SpringEmbeddedCacheManager(EmbeddedCacheManager nativeCacheManager, boolean reactive) {
        Assert.notNull((Object)nativeCacheManager, (String)"A non-null instance of EmbeddedCacheManager needs to be supplied");
        this.nativeCacheManager = nativeCacheManager;
        this.reactive = reactive;
    }

    public SpringCache getCache(String name) {
        return this.springCaches.computeIfAbsent(name, n -> {
            Cache nativeCache = this.nativeCacheManager.getCache(n);
            return new SpringCache((BasicCache)nativeCache, this.reactive);
        });
    }

    public Collection<String> getCacheNames() {
        return this.nativeCacheManager.getCacheNames();
    }

    public EmbeddedCacheManager getNativeCacheManager() {
        return this.nativeCacheManager;
    }

    public void stop() {
        this.nativeCacheManager.stop();
        this.springCaches.clear();
    }
}

