/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.embedded.metrics;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.infinispan.Cache;
import org.infinispan.spring.starter.embedded.metrics.InfinispanCacheMeterBinder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.cache.metrics.CacheMeterBinderProvider;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="infinispanCacheMeterBinderProvider")
@ConditionalOnClass(name={"org.springframework.boot.cache.metrics.CacheMeterBinderProvider"})
@ConditionalOnProperty(value={"infinispan.embedded.enabled"}, havingValue="true", matchIfMissing=true)
public class InfinispanCacheMeterBinderProvider
implements CacheMeterBinderProvider<org.springframework.cache.Cache> {
    public static final String NAME = "infinispanCacheMeterBinderProvider";

    public MeterBinder getMeterBinder(org.springframework.cache.Cache cache, Iterable<Tag> tags) {
        Object nativeCache = cache.getNativeCache();
        InfinispanCacheMeterBinder meterBinder = null;
        if (nativeCache instanceof Cache) {
            meterBinder = new InfinispanCacheMeterBinder((Cache)nativeCache, tags);
        }
        return meterBinder;
    }
}

