/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote.actuator;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.starter.remote.actuator.RemoteInfinispanCacheMeterBinder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="remoteInfinispanCacheMeterBinderProvider")
@ConditionalOnClass(name={"org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider"})
@ConditionalOnProperty(value={"infinispan.remote.enabled"}, havingValue="true", matchIfMissing=true)
public class RemoteInfinispanCacheMeterBinderProvider
implements CacheMeterBinderProvider<SpringCache> {
    public static final String NAME = "remoteInfinispanCacheMeterBinderProvider";

    public MeterBinder getMeterBinder(SpringCache cache, Iterable<Tag> tags) {
        if (cache.getNativeCache() instanceof RemoteCache) {
            return new RemoteInfinispanCacheMeterBinder((RemoteCache)cache.getNativeCache(), tags);
        }
        return null;
    }
}

