/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.core.rollingupgrade.CombinedInfinispanServerDriver;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfigurationBuilder;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeHandler;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeVersion;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeXSiteHandler;
import org.infinispan.server.test.junit5.InfinispanServerExtensionBuilder;
import org.infinispan.server.test.junit5.InfinispanXSiteServerExtension;
import org.infinispan.server.test.junit5.InfinispanXSiteServerExtensionBuilder;
import org.infinispan.server.test.junit5.RollingUpgradeHandlerExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RollingUpgradeHandlerXSiteExtension
extends InfinispanXSiteServerExtension {
    private final Map<String, RollingUpgradeConfiguration> sites;
    private RollingUpgradeXSiteHandler handler;

    private RollingUpgradeHandlerXSiteExtension(Class<?> caller, Map<String, InfinispanServerExtensionBuilder> sites, RollingUpgradeVersion fromVersion, RollingUpgradeVersion toVersion, Consumer<RollingUpgradeConfigurationBuilder> decorator) {
        super(new ArrayList<TestServer>());
        this.sites = sites.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            RollingUpgradeConfigurationBuilder builder = RollingUpgradeHandlerExtension.convertBuilder(caller.getName() + "-" + (String)e.getKey(), (InfinispanServerExtensionBuilder)((Object)((Object)e.getValue())), fromVersion, toVersion);
            decorator.accept(builder);
            return builder.build();
        }));
    }

    public static RollingUpgradeHandlerXSiteExtension from(Class<?> caller, InfinispanXSiteServerExtensionBuilder builder, RollingUpgradeVersion fromVersion, RollingUpgradeVersion toVersion) {
        return RollingUpgradeHandlerXSiteExtension.from(caller, builder, fromVersion, toVersion, ignore -> {});
    }

    public static RollingUpgradeHandlerXSiteExtension from(Class<?> caller, InfinispanXSiteServerExtensionBuilder builder, RollingUpgradeVersion fromVersion, RollingUpgradeVersion toVersion, Consumer<RollingUpgradeConfigurationBuilder> decorator) {
        return new RollingUpgradeHandlerXSiteExtension(caller, builder.siteConfigurations(), fromVersion, toVersion, decorator);
    }

    @Override
    protected void onTestsStart(ExtensionContext extensionContext) throws InterruptedException {
        if (this.handler == null) {
            this.handler = RollingUpgradeXSiteHandler.startOldClusters(this.sites);
            for (String siteName : this.sites.keySet()) {
                RollingUpgradeHandler handler = this.handler.handlerForSite(siteName);
                handler.upgradeNewNode();
                this.testServers.add(new TestServer(handler.getFromConfig(), (InfinispanServerDriver)new CombinedInfinispanServerDriver(handler.getFromDriver(), handler.getToDriver())));
            }
        }
    }

    @Override
    protected void onTestsComplete(ExtensionContext extensionContext) {
        if (this.handler != null) {
            this.testServers.forEach(TestServer::afterListeners);
            try {
                if (extensionContext.getExecutionException().isPresent()) {
                    this.handler.exceptionEncountered((Throwable)extensionContext.getExecutionException().get());
                } else {
                    this.handler.completeUpgrade(false);
                }
            }
            finally {
                this.handler.close();
            }
        }
    }
}

