/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.net.InetAddress;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.JmxTestClient;
import org.infinispan.server.test.api.MemcachedTestClientDriver;
import org.infinispan.server.test.api.RespTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientDriver;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit5.AbstractServerExtension;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InfinispanServerExtension
extends AbstractServerExtension
implements TestClientDriver,
BeforeEachCallback,
AfterEachCallback {
    private final TestServer testServer;
    private TestClient testClient;

    public InfinispanServerExtension(InfinispanServerTestConfiguration configuration) {
        this.testServer = new TestServer(configuration);
    }

    @Override
    protected void onTestsStart(ExtensionContext extensionContext) throws Exception {
        this.startTestServer(extensionContext, this.testServer);
    }

    @Override
    protected void onTestsComplete(ExtensionContext extensionContext) {
        if (this.testServer.isDriverInitialized()) {
            this.stopTestServer(extensionContext, this.testServer);
        }
        this.testServer.afterListeners();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.testClient = new TestClient(this.testServer);
        this.startTestClient(extensionContext, this.testClient);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.testClient.clearResources();
    }

    public void assumeContainerMode() {
        Assumptions.assumeTrue((boolean)(this.getServerDriver() instanceof ContainerInfinispanServerDriver), (String)"Requires CONTAINER mode");
    }

    public HotRodTestClientDriver hotrod() {
        return this.testClient.hotrod();
    }

    public RestTestClientDriver rest() {
        return this.testClient.rest();
    }

    public RespTestClientDriver resp() {
        return this.testClient.resp();
    }

    public MemcachedTestClientDriver memcached() {
        return this.testClient.memcached();
    }

    public JmxTestClient jmx() {
        return this.testClient.jmx();
    }

    public String getMethodName() {
        return this.testClient.getMethodName();
    }

    public String getMethodName(String qualifier) {
        return this.testClient.getMethodName(new Object[]{qualifier});
    }

    public CounterManager getCounterManager() {
        return this.testClient.getCounterManager();
    }

    public InetAddress getServerAddress(int offset) {
        return this.getServerDriver().getServerAddress(offset);
    }

    public TestServer getTestServer() {
        return this.testServer;
    }

    public InfinispanServerDriver getServerDriver() {
        return this.testServer.getDriver();
    }

    public String addScript(RemoteCacheContainer remoteCacheManager, String script) {
        return this.testClient.addScript(remoteCacheManager, script);
    }

    public boolean isContainerized() {
        return this.testServer.getDriver() instanceof ContainerInfinispanServerDriver;
    }
}

