/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import org.infinispan.server.test.junit5.InfinispanServer;
import org.infinispan.server.test.junit5.InfinispanSuite;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class CustomInfinispanExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    public static final String EXTENSION_OVERRIDE = "org.infinispan.server.test.junit5.extension";

    private static void invokeMethodIfPresent(ExtensionContext context, String methodName) {
        CustomInfinispanExtension.invokeMethodIfPresent(AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), InfinispanServer.class, ModifierSupport::isStatic), context, methodName);
    }

    private static void invokeMethodIfPresent(List<Field> fields, ExtensionContext context, String methodName) {
        fields.forEach(f -> {
            try {
                Object is = f.get(null);
                if (is != null) {
                    ReflectionSupport.findMethod(is.getClass(), (String)methodName, (Class[])new Class[]{ExtensionContext.class}).ifPresent(m -> ReflectionSupport.invokeMethod((Method)m, (Object)is, (Object[])new Object[]{context}));
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public void afterAll(ExtensionContext extensionContext) {
        CustomInfinispanExtension.invokeMethodIfPresent(extensionContext, "afterAll");
    }

    public void afterEach(ExtensionContext extensionContext) {
        CustomInfinispanExtension.invokeMethodIfPresent(extensionContext, "afterEach");
    }

    public void beforeAll(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        List fields = AnnotationSupport.findAnnotatedFields((Class)testClass, InfinispanServer.class, ModifierSupport::isStatic);
        fields.forEach(f -> {
            try {
                Object is = f.get(null);
                Class<?> fieldType = f.getType();
                if (is == null) {
                    Class<InfinispanSuite> suiteClass;
                    String override = System.getProperty(EXTENSION_OVERRIDE);
                    if (override != null) {
                        try {
                            Class<?> possibleClass = Class.forName(override);
                            if (!InfinispanSuite.class.isAssignableFrom(possibleClass)) {
                                throw new IllegalArgumentException("System property defined class name: " + override + " does not extend " + InfinispanSuite.class.getName());
                            }
                            suiteClass = possibleClass;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("System property defined class name: " + override + " for extension override is not found!", e);
                        }
                    } else {
                        InfinispanServer ann = f.getAnnotation(InfinispanServer.class);
                        suiteClass = ann.value();
                    }
                    List extensionFields = AnnotationSupport.findAnnotatedFields(suiteClass, RegisterExtension.class, possibleField -> {
                        try {
                            return ModifierSupport.isStatic((Member)possibleField) && fieldType.isAssignableFrom(possibleField.get(null).getClass());
                        }
                        catch (IllegalAccessException e) {
                            return false;
                        }
                    });
                    if (extensionFields.size() != 1) {
                        throw new IllegalStateException("Test " + String.valueOf(testClass) + " was ran without an explicit Suite explicit RegisterExtension and its default suite class " + String.valueOf(suiteClass) + " doesn't have a single static @RegisterExtension field that is assignable to type: " + String.valueOf(fieldType) + ", had " + String.valueOf(extensionFields));
                    }
                    is = ((Field)extensionFields.get(0)).get(null);
                    f.set(null, is);
                }
                Object finalIs = is;
                ReflectionSupport.findMethod(is.getClass(), (String)"beforeAll", (Class[])new Class[]{ExtensionContext.class}).ifPresent(m -> ReflectionSupport.invokeMethod((Method)m, (Object)finalIs, (Object[])new Object[]{extensionContext}));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public void beforeEach(ExtensionContext extensionContext) {
        CustomInfinispanExtension.invokeMethodIfPresent(extensionContext, "beforeEach");
    }
}

