/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.server.test.core.AbstractServerConfigBuilder;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit5.InfinispanServerExtensionBuilder;
import org.infinispan.server.test.junit5.InfinispanXSiteServerExtension;

public class InfinispanXSiteServerExtensionBuilder {
    private final List<InfinispanServerExtensionBuilder> sites = new ArrayList<InfinispanServerExtensionBuilder>();

    public InfinispanXSiteServerExtensionBuilder addSite(String siteName, InfinispanServerExtensionBuilder siteBuilder) {
        siteBuilder.site(siteName);
        this.sites.add(siteBuilder);
        return this;
    }

    public Map<String, InfinispanServerExtensionBuilder> siteConfigurations() {
        return this.sites.stream().collect(Collectors.toMap(AbstractServerConfigBuilder::site, Function.identity()));
    }

    public InfinispanXSiteServerExtension build() {
        HashSet uniqueSiteName = new HashSet();
        List<TestServer> testServers = this.sites.stream().map(it -> new TestServer(it.createServerTestConfiguration())).peek(testServer -> {
            if (!uniqueSiteName.add(testServer.getSiteName())) {
                throw new IllegalStateException("Site name already set: " + testServer.getSiteName());
            }
        }).collect(Collectors.toList());
        return new InfinispanXSiteServerExtension(testServers);
    }
}

