/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.MemcachedTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientXSiteDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanXSiteServerTestMethodRule
implements TestRule,
TestClientXSiteDriver {
    private final Map<String, TestClient> testClients = new HashMap<String, TestClient>();

    public InfinispanXSiteServerTestMethodRule(InfinispanXSiteServerRule serverRule) {
        Objects.requireNonNull(serverRule, "InfinispanServerRule class Rule is null");
        serverRule.getTestServers().forEach(it -> this.testClients.put(it.getSiteName(), new TestClient(it)));
    }

    public String getMethodName() {
        return this.testClients.values().iterator().next().getMethodName();
    }

    public String hostAndPort(String siteName) {
        throw new UnsupportedOperationException();
    }

    public HotRodTestClientDriver hotrod(String siteName) {
        return this.testClients.get(siteName).hotrod();
    }

    public RestTestClientDriver rest(String siteName) {
        return this.testClients.get(siteName).rest();
    }

    public MemcachedTestClientDriver memcached(String siteName) {
        return this.testClients.get(siteName).memcached();
    }

    public CounterManager getCounterManager(String siteName) {
        return this.testClients.get(siteName).getCounterManager();
    }

    public <K, V> MultimapCacheManager<K, V> getMultimapCacheManager(String siteName) {
        return this.testClients.get(siteName).getRemoteMultimapCacheManager();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(this){
            final /* synthetic */ InfinispanXSiteServerTestMethodRule this$0;
            {
                this.this$0 = this$0;
            }

            public void evaluate() throws Throwable {
                try {
                    this.this$0.testClients.values().forEach(testClient -> {
                        testClient.initResources();
                        testClient.setMethodName(description.getTestClass().getSimpleName() + "." + description.getMethodName());
                    });
                    base.evaluate();
                }
                finally {
                    this.this$0.testClients.values().forEach(TestClient::clearResources);
                }
            }
        };
    }
}

