/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.rollingupgrade;

import java.io.Closeable;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import net.spy.memcached.ConnectionFactoryBuilder;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;

public class CombinedInfinispanServerDriver
implements InfinispanServerDriver {
    private final ContainerInfinispanServerDriver fromDriver;
    private final ContainerInfinispanServerDriver toDriver;

    public CombinedInfinispanServerDriver(ContainerInfinispanServerDriver fromDriver, ContainerInfinispanServerDriver toDriver) {
        this.fromDriver = fromDriver;
        this.toDriver = toDriver;
    }

    @Override
    public InetAddress getTestHostAddress() {
        return this.fromDriver.getTestHostAddress();
    }

    @Override
    public void prepare(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getCertificateFile(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getRootDir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getConfDir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName, String type, String provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName, String type, String provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName, String type, String provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName, String type, String provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTrustStore(ConnectionFactoryBuilder builder, String certificateName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTrustStore(ConnectionFactoryBuilder builder, String certificateName, String type, String provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pause(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void kill(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restart(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restartCluster() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopCluster() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void killCluster() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String syncFilesFromServer(int server, String dir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String syncFilesToServer(int server, String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.fromDriver.getStatus();
    }

    @Override
    public InfinispanServerTestConfiguration getConfiguration() {
        return this.fromDriver.getConfiguration();
    }

    protected ContainerInfinispanServerDriver driverToUse(int server) {
        if (this.fromDriver.isRunning(server)) {
            return this.fromDriver;
        }
        return this.toDriver;
    }

    protected int offsetToUse(ContainerInfinispanServerDriver driverUsed, int server) {
        if (driverUsed == this.fromDriver) {
            return server;
        }
        return this.fromDriver.serverCount() - 1 - server;
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server, String username, String password, Consumer<Closeable> reaper) {
        ContainerInfinispanServerDriver driver = this.driverToUse(server);
        return driver.getJmxConnection(this.offsetToUse(driver, server), username, password, reaper);
    }

    @Override
    public RemoteCacheManager createRemoteCacheManager(ConfigurationBuilder builder) {
        return new RemoteCacheManager(builder.build());
    }

    @Override
    public int getTimeout() {
        return this.fromDriver.getTimeout();
    }

    @Override
    public boolean isRunning(int server) {
        return this.fromDriver.serverCount() >= server;
    }

    @Override
    public int serverCount() {
        return this.fromDriver.serverCount();
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        ContainerInfinispanServerDriver driver = this.driverToUse(server);
        return driver.getServerSocket(this.offsetToUse(driver, server), port);
    }

    @Override
    public InetAddress getServerAddress(int server) {
        ContainerInfinispanServerDriver driver = this.driverToUse(server);
        return driver.getServerAddress(this.offsetToUse(driver, server));
    }
}

