/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.compatibility;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.jdkspecific.CallerId;
import org.infinispan.server.test.core.compatibility.CompatibilityEntry;
import org.infinispan.server.test.core.compatibility.ExceptionDetail;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;

public record Compatibility(List<CompatibilityEntry> compatibility) {
    public static Compatibility INSTANCE = Compatibility.load("compatibility.json");

    private static Compatibility load(String name) {
        InputStream is = Compatibility.class.getClassLoader().getResourceAsStream(name);
        if (is != null) {
            Compatibility compatibility;
            block9: {
                InputStream inputStream = is;
                try {
                    compatibility = (Compatibility)new ObjectMapper().readValue(is, Compatibility.class);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                inputStream.close();
            }
            return compatibility;
        }
        return new Compatibility(Collections.emptyList());
    }

    public boolean isCompatibilitySkip(RollingUpgradeConfiguration configuration) {
        String callerClass = CallerId.getCallerClass((int)2).getName();
        String callerMethodName = CallerId.getCallerMethodName((int)2);
        return this.isCompatibilitySkip(configuration, callerClass, callerMethodName);
    }

    public boolean isCompatibilitySkip(RollingUpgradeConfiguration configuration, String className, String methodName) {
        Optional<String> found = this.compatibility.stream().filter(e -> e.matchesVersions(configuration.fromVersion().version(), configuration.toVersion().version())).flatMap(e -> e.exceptions().stream()).flatMap(e -> e.testFailures().stream()).filter(e -> e.testClass().equals(className)).flatMap(e -> e.testMethods().stream()).filter(e -> e.equals(methodName)).findFirst();
        return found.isPresent();
    }

    public CompatibilityEntry compatibilityEntry(RollingUpgradeConfiguration configuration) {
        return this.compatibility.stream().filter(e -> e.matchesVersions(configuration.fromVersion().version(), configuration.toVersion().version())).findFirst().orElse(CompatibilityEntry.EMPTY);
    }

    public static void main(String[] args) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("[cols=\"1,1,5\"]\n");
        sb.append("|===\n");
        sb.append("|From version |To version |Exceptions\n\n");
        if (INSTANCE.compatibility() != null) {
            for (CompatibilityEntry entry : INSTANCE.compatibility()) {
                sb.append("|`").append(entry.versionFrom() != null ? entry.versionFrom() : "N/A").append("`\n");
                sb.append("|`").append(entry.versionTo() != null ? entry.versionTo() : "N/A").append("`\n");
                sb.append("a|");
                if (entry.exceptions() != null && !entry.exceptions().isEmpty()) {
                    sb.append("!===\n");
                    sb.append("!Issue !Description\n\n");
                    for (ExceptionDetail ex : entry.exceptions()) {
                        sb.append("! link:").append(ex.issue()).append("[#").append(ex.issue().substring(ex.issue().lastIndexOf(47) + 1)).append("]\n");
                        sb.append("! ").append(Compatibility.escapeAsciiDoc(ex.description())).append("\n");
                    }
                    sb.append("!===\n");
                } else {
                    sb.append("None\n");
                }
                sb.append("\n");
            }
        }
        sb.append("|===");
        Files.writeString(Paths.get(args[0], new String[0]), (CharSequence)sb, new OpenOption[0]);
    }

    private static String escapeAsciiDoc(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("|", "\\|");
    }
}

