/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Closeable;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.testing.Exceptions;

public class TestServer {
    protected InfinispanServerDriver serverDriver;
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();
    protected InfinispanServerTestConfiguration configuration;

    public TestServer(InfinispanServerTestConfiguration configuration) {
        this.configuration = configuration;
    }

    public TestServer(InfinispanServerTestConfiguration configuration, InfinispanServerDriver serverDriver) {
        this.configuration = configuration;
        this.serverDriver = serverDriver;
    }

    public boolean isDriverInitialized() {
        return this.serverDriver != null;
    }

    public InfinispanServerDriver getDriver() {
        if (this.serverDriver == null) {
            throw new IllegalStateException("ServerDriver is null. Server driver not initialized");
        }
        return this.serverDriver;
    }

    public void stopServerDriver(String testName) {
        if (this.serverDriver == null) {
            return;
        }
        this.getDriver().stop(testName);
        this.serverDriver = null;
    }

    public RemoteCacheManager newHotRodClient() {
        return this.newHotRodClient(new ConfigurationBuilder());
    }

    public RemoteCacheManager newHotRodClient(ConfigurationBuilder builder) {
        return this.newHotRodClient(builder, this.getDefaultPortNumber());
    }

    public RemoteCacheManager newHotRodClient(ConfigurationBuilder builder, int port) {
        if (builder.servers().isEmpty()) {
            for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
                this.configureHotRodClient(builder, port, i);
            }
        }
        return this.getDriver().createRemoteCacheManager(builder);
    }

    public RemoteCacheManager newHotRodClient(ConfigurationBuilder builder, int port, int index) {
        this.configureHotRodClient(builder, port, index);
        return this.getDriver().createRemoteCacheManager(builder);
    }

    private void configureHotRodClient(ConfigurationBuilder builder, int port, int i) {
        InetSocketAddress serverAddress = this.getDriver().getServerSocket(i, port);
        builder.addServer().host(serverAddress.getHostString()).port(serverAddress.getPort());
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder) {
        return this.newRestClient(builder, this.getDefaultPortNumber());
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder, int port) {
        if (builder.servers().isEmpty()) {
            for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
                InetSocketAddress serverAddress = this.getDriver().getServerSocket(i, port);
                builder.addServer().host(serverAddress.getHostString()).port(serverAddress.getPort());
            }
        }
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    public CloseableMemcachedClient newMemcachedClient(ConnectionFactoryBuilder builder) {
        return this.newMemcachedClient(builder, this.getDefaultPortNumber());
    }

    public CloseableMemcachedClient newMemcachedClient(ConnectionFactoryBuilder builder, int port) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress unresolved = this.getDriver().getServerSocket(i, port);
            addresses.add(new InetSocketAddress(unresolved.getHostString(), unresolved.getPort()));
        }
        builder.setClientMode(ClientMode.Static);
        MemcachedClient memcachedClient = (MemcachedClient)Exceptions.unchecked(() -> new MemcachedClient(builder.build(), addresses));
        return new CloseableMemcachedClient(memcachedClient);
    }

    public void beforeListeners() {
        this.configuration.listeners().forEach(l -> l.before(this.serverDriver));
    }

    public void afterListeners() {
        this.configuration.listeners().forEach(l -> l.after(this.serverDriver));
    }

    public boolean isContainerRunWithDefaultServerConfig() {
        return this.configuration.isDefaultFile() && this.configuration.runMode() == ServerRunMode.CONTAINER;
    }

    public RestClient newRestClientForServer(RestClientConfigurationBuilder builder, int port, int n) {
        InetSocketAddress serverAddress = this.getDriver().getServerSocket(n, port);
        builder.addServer().host(serverAddress.getHostString()).port(serverAddress.getPort());
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    public void add(Consumer<File> enhancer) {
        this.configurationEnhancers.add(enhancer);
    }

    public void initServerDriver() {
        this.serverDriver = this.configuration.runMode().newDriver(this.configuration);
    }

    public void enhanceConfiguration() {
        this.configurationEnhancers.forEach(c -> c.accept(this.serverDriver.getConfDir()));
    }

    public boolean hasCrossSiteEnabled() {
        return this.configuration.site() != null;
    }

    public String getSiteName() {
        return this.configuration.site();
    }

    public int getDefaultPortNumber() {
        return 11222;
    }

    public record CloseableMemcachedClient(MemcachedClient client) implements Closeable
    {
        @Override
        public void close() {
            this.client.shutdown();
        }
    }
}

