/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.OS;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.ForkedServer;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.testing.Exceptions;
import org.infinispan.testing.Testing;

public class ForkedInfinispanServerDriver
extends AbstractInfinispanServerDriver {
    private static final Log log = LogFactory.getLog(ForkedInfinispanServerDriver.class);
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 15;
    private final List<ForkedServer> forkedServers = new ArrayList<ForkedServer>();
    private final List<Path> serverHomes;
    private final String serverDataPath;

    protected ForkedInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, InetAddress.getLoopbackAddress());
        String globalServerHome = configuration.properties().getProperty("org.infinispan.test.server.dir");
        if (globalServerHome == null || globalServerHome.isEmpty()) {
            throw new IllegalArgumentException("You must specify a org.infinispan.test.server.dir property.");
        }
        this.serverDataPath = System.getProperty("infinispan.server.root.path");
        if (this.serverDataPath != null && !this.serverDataPath.trim().isEmpty() && !this.serverDataPath.contains("%d")) {
            throw new IllegalStateException("Server root path should have the index. Add the %d regex to the path. Example: /path/to/server_%d");
        }
        this.serverHomes = new ArrayList<Path>();
        Path src = Paths.get(globalServerHome, new String[0]).normalize();
        this.copyServer(src, this.serverDataPath != null ? 1 : configuration.numServers());
    }

    private void copyServer(Path src, int maxServers) {
        for (int i = 0; i < maxServers; ++i) {
            Path dest = Paths.get(Testing.tmpDirectory(), Util.threadLocalRandomUUID().toString());
            try {
                Files.createDirectory(dest, new FileAttribute[0]);
                Files.walkFileTree(src, (FileVisitor<? super Path>)new Testing.CopyFileVisitor(dest, true));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot copy the server to temp folder", e);
            }
            this.serverHomes.add(dest);
        }
    }

    private Path getServerConfDir(String home) {
        return Paths.get(home, "server", "conf");
    }

    @Override
    public void prepare(String name) {
    }

    @Override
    protected void start(String name, File rootDir) {
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            ForkedServer server;
            Path destConfDir;
            if (this.serverDataPath != null) {
                serverHome = this.serverHomes.get(0).toString();
                File serverRootPath = new File(String.format(this.serverDataPath, i));
                this.createServerStructure(serverHome, serverRootPath);
                destConfDir = this.getServerConfDir(serverRootPath.getAbsolutePath());
                server = new ForkedServer(serverHome);
                server.addSystemProperty("infinispan.server.root.path", serverRootPath);
            } else {
                serverHome = this.serverHomes.get(i).toString();
                destConfDir = this.getServerConfDir(serverHome);
                server = new ForkedServer(serverHome);
            }
            server.setServerConfiguration(new File(this.configuration.configurationFile()).getPath()).setPortsOffset(i);
            server.addSystemProperty("infinispan.cluster.stack", System.getProperty("infinispan.cluster.stack"));
            if (i == 0 && this.configuration.site() == null && !Boolean.parseBoolean(this.configuration.properties().getProperty("org.infinispan.test.server.requireJoinTimeout"))) {
                server.addSystemProperty("jgroups.join_timeout", "0");
            }
            try {
                File sourceServerConfiguration = new File(server.getServerConfiguration());
                Files.copy(Paths.get(server.getServerConfiguration(), new String[0]), destConfDir.resolve(sourceServerConfiguration.getName()), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot copy the server to temp directory", e);
            }
            if (i == 99) {
                server.setJvmOptions(this.debugJvmOption());
            }
            if (this.configuration.isJMXEnabled()) {
                server.addArgument("--jmx 9999");
            }
            this.copyArtifactsToUserLibDir(server.getServerLib());
            this.forkedServers.add(server.start());
        }
    }

    private void createServerStructure(String serverHome, File serverRootPath) {
        try {
            Util.recursiveFileRemove((File)serverRootPath);
            Util.recursiveDirectoryCopy((Path)this.getServerConfDir(serverHome).getParent(), (Path)serverRootPath.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot copy the default values", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stop() {
        try {
            try (RestClient restClient = this.getRestClient(0);){
                RestResponse response = (RestResponse)ForkedInfinispanServerDriver.sync(restClient.cluster().stop());
                if (response.status() >= 400) {
                    throw new IllegalStateException(String.format("Failed to shutdown the cluster gracefully, got status %d.", response.status()));
                }
                boolean javaProcessQuit = false;
                long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(15L);
                while (!javaProcessQuit && endTime >= System.currentTimeMillis()) {
                    try {
                        this.forkedServers.get(0).getPid();
                        Thread.sleep(500L);
                    }
                    catch (IllegalStateException ignore) {
                        javaProcessQuit = true;
                    }
                }
                if (!javaProcessQuit) {
                    throw new IllegalStateException("Server Java process has not gracefully quit within 15 seconds.");
                }
            }
            catch (RuntimeException e) {
                log.warn((Object)"Server is not running", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)"Got exception while gracefully shutting down the cluster. Killing the servers.", (Throwable)e);
            for (int i = 0; i < this.configuration.numServers(); ++i) {
                try {
                    this.kill(i);
                    continue;
                }
                catch (Exception exception) {
                    log.errorf("Failed to kill server #%d, exception was: %s", (Object)i, (Object)exception);
                }
            }
        }
        finally {
            for (int i = 0; i < this.configuration.numServers(); ++i) {
                if (i >= this.forkedServers.size()) continue;
                this.forkedServers.get(i).stopInternal();
            }
        }
    }

    @Override
    public void stop(int server) {
        ForkedInfinispanServerDriver.sync(this.getRestClient(server).server().stop());
    }

    @Override
    public boolean isRunning(int server) {
        try {
            ForkedInfinispanServerDriver.sync(this.getRestClient(server).server().configuration());
        }
        catch (RuntimeException r) {
            return !(Util.getRootCause((Throwable)r) instanceof ConnectException);
        }
        return true;
    }

    @Override
    public int serverCount() {
        return this.forkedServers.size();
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        return new InetSocketAddress(this.getServerAddress(server), this.getServerPort(server, port));
    }

    @Override
    public InetAddress getServerAddress(int server) {
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName("localhost"));
    }

    @Override
    public void pause(int server) {
        if (OS.getCurrentOs() == OS.WINDOWS) {
            throw new UnsupportedOperationException("Forked mode does not support pause on Windows!");
        }
        Exceptions.unchecked(() -> new ProcessBuilder("kill", "-SIGSTOP", String.valueOf(this.forkedServers.get(server).getPid())).start().waitFor(15L, TimeUnit.SECONDS));
    }

    @Override
    public void resume(int server) {
        if (OS.getCurrentOs() == OS.WINDOWS) {
            throw new UnsupportedOperationException("Forked mode does not support resume on Windows!");
        }
        Exceptions.unchecked(() -> new ProcessBuilder("kill", "-SIGCONT", String.valueOf(this.forkedServers.get(server).getPid())).start().waitFor(15L, TimeUnit.SECONDS));
    }

    @Override
    public void kill(int server) {
        String pid = String.valueOf(this.forkedServers.get(server).getPid());
        if (OS.getCurrentOs() == OS.WINDOWS) {
            Exceptions.unchecked(() -> new ProcessBuilder("TASKKILL", "/PID", pid, "/F", "/T").start().waitFor(15L, TimeUnit.SECONDS));
        } else {
            Exceptions.unchecked(() -> new ProcessBuilder("kill", "-9", pid).start().waitFor(15L, TimeUnit.SECONDS));
        }
    }

    @Override
    public void restart(int server) {
        throw new UnsupportedOperationException("Forked mode does not support restart!");
    }

    @Override
    public void restartCluster() {
        throw new UnsupportedOperationException("Forked mode does not support cluster restart!");
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server, String username, String password, Consumer<Closeable> reaper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTimeout() {
        return ForkedServer.TIMEOUT_SECONDS;
    }

    private RestClient getRestClient(int server) {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        Properties securityConfigurationProperties = new Properties();
        this.configuration.properties().entrySet().stream().filter(entry -> entry.getKey().toString().startsWith("infinispan.client.rest.")).forEach(entry -> securityConfigurationProperties.put(entry.getKey(), entry.getValue()));
        builder.withProperties(securityConfigurationProperties);
        log.debugf("Configured client with the following properties: %s", (Object)securityConfigurationProperties.keySet().toString());
        builder.addServer().host("localhost").port(this.getServerPort(server, ForkedServer.DEFAULT_SINGLE_PORT));
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    private int getServerPort(int server, int port) {
        return port + 100 * server;
    }

    private static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(15L, TimeUnit.SECONDS));
    }

    @Override
    public String syncFilesFromServer(int server, String dir) {
        return this.getRootDir().toPath().resolve(Integer.toString(server)).toString();
    }

    @Override
    public String syncFilesToServer(int server, String path) {
        return path;
    }
}

