/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import java.net.InetAddress;
import org.infinispan.testing.Exceptions;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;

public class Containers {
    public static final DockerClient DOCKER_CLIENT = DockerClientFactory.instance().client();

    public static String ipAddress(GenericContainer<?> container) {
        return ((ContainerNetwork)container.getContainerInfo().getNetworkSettings().getNetworks().values().iterator().next()).getIpAddress();
    }

    public static InetAddress getContainerNetworkGateway() {
        return Containers.getContainerNetworkGateway("bridge");
    }

    public static InetAddress getContainerNetworkGateway(String id) {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        Network bridge = dockerClient.inspectNetworkCmd().withNetworkId(id).exec();
        String gateway = ((Network.Ipam.Config)bridge.getIpam().getConfig().get(0)).getGateway();
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName(gateway));
    }

    public static String imageArchitecture() {
        return switch (System.getProperty("os.arch")) {
            case "x86_64", "amd64" -> "amd64";
            case "aarch64" -> "arm64";
            default -> throw new IllegalArgumentException("Unknown architecture");
        };
    }
}

