/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.infinispan.commons.util.SecurityProviders;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateChainAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public class CertificateAuthority {
    public static final String DEFAULT_BASE_DN = "OU=server,DC=infinispan,DC=org";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final Provider[] ALL_PROVIDERS = SecurityProviders.discoverSecurityProviders((ClassLoader)CertificateAuthority.class.getClassLoader());
    private final String baseDN;
    private final SelfSignedX509CertificateAndSigningKey ca;
    private final Map<String, X509CertificateChainAndSigningKey> certificates = new HashMap<String, X509CertificateChainAndSigningKey>();
    protected final AtomicLong certSerial = new AtomicLong(1L);
    private final KeyPairGenerator keyPairGenerator;

    public CertificateAuthority() {
        this(DEFAULT_BASE_DN);
    }

    public CertificateAuthority(String baseDN) {
        this.baseDN = baseDN;
        this.ca = SelfSignedX509CertificateAndSigningKey.builder().setDn(this.dn("CA")).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setKeyAlgorithmName(KEY_ALGORITHM).addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        this.certificates.put("ca", new X509CertificateChainAndSigningKey(new X509Certificate[]{this.ca.getSelfSignedCertificate()}, this.ca.getSigningKey()));
        Provider provider = ProviderUtil.findProvider((Provider[])ALL_PROVIDERS, null, KeyPairGenerator.class, (String)KEY_ALGORITHM);
        try {
            this.keyPairGenerator = provider != null ? KeyPairGenerator.getInstance(KEY_ALGORITHM, provider) : KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public X509CertificateChainAndSigningKey getCertificate(String name) {
        return this.getCertificate(name, null);
    }

    public X509CertificateChainAndSigningKey getCertificate(String name, InetAddress host) {
        return this.certificates.computeIfAbsent(name, n -> {
            KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
            PrivateKey signingKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            X509Certificate caCertificate = this.ca.getSelfSignedCertificate();
            ArrayList<Object> sANs = new ArrayList<Object>();
            sANs.add(new GeneralName.DNSName("infinispan.test"));
            sANs.add(new GeneralName.DNSName("localhost"));
            if (host != null) {
                byte[] address = host.getAddress();
                while (address[3] != -1) {
                    try {
                        sANs.add(new GeneralName.IPAddress(InetAddress.getByAddress(address).getHostAddress()));
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                    address[3] = (byte)(address[3] + 1);
                }
            }
            try {
                X509Certificate certificate = new X509CertificateBuilder().setIssuerDn(this.ca.getSelfSignedCertificate().getSubjectX500Principal()).setSubjectDn(this.dn(name)).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setSigningKey(this.ca.getSigningKey()).setPublicKey(publicKey).setSerialNumber(BigInteger.valueOf(this.certSerial.getAndIncrement())).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).addExtension((X509CertificateExtension)new SubjectAlternativeNamesExtension(false, sANs)).build();
                return new X509CertificateChainAndSigningKey(new X509Certificate[]{certificate, caCertificate}, signingKey);
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Path exportCertificateWithKey(String name, Path toPath, char[] password, ExportType exportType) throws IOException, GeneralSecurityException {
        X509CertificateChainAndSigningKey certificate = this.getCertificate(name);
        Files.createDirectories(toPath, new FileAttribute[0]);
        Path path = toPath.resolve(name + "." + exportType.ext());
        switch (exportType.ordinal()) {
            case 0: 
            case 1: {
                KeyStore keyStore = CertificateAuthority.getKeyStore(exportType.providerName, exportType.type);
                keyStore.setKeyEntry(name, certificate.getSigningKey(), password, certificate.getCertificateChain());
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    keyStore.store(os, password);
                    break;
                }
            }
            case 2: {
                try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
                    w.write("-----BEGIN PRIVATE KEY-----\n");
                    w.write(Base64.getEncoder().encodeToString(certificate.getSigningKey().getEncoded()));
                    w.write("\n-----END PRIVATE KEY-----\n");
                    for (X509Certificate cert : certificate.getCertificateChain()) {
                        w.write("-----BEGIN CERTIFICATE-----\n");
                        w.write(Base64.getEncoder().encodeToString(cert.getEncoded()));
                        w.write("\n-----END CERTIFICATE-----\n");
                    }
                    break;
                }
            }
            case 4: {
                try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
                    w.write("-----BEGIN PRIVATE KEY-----\n");
                    w.write(Base64.getEncoder().encodeToString(certificate.getSigningKey().getEncoded()));
                    w.write("\n-----END PRIVATE KEY-----\n");
                }
            }
            default: {
                throw new IllegalArgumentException(exportType.name());
            }
        }
        return path;
    }

    public void exportCertificates(Path path, ExportType exportType, char[] password, String ... names) throws GeneralSecurityException, IOException {
        if (names == null || names.length == 0) {
            names = this.certificates.keySet().toArray(new String[0]);
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        switch (exportType.ordinal()) {
            case 0: 
            case 1: {
                KeyStore keyStore = CertificateAuthority.getKeyStore(exportType.providerName, exportType.type);
                for (String name : names) {
                    keyStore.setCertificateEntry(name, this.getCertificate(name).getCertificateChain()[0]);
                }
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    keyStore.store(os, password);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException(exportType.name());
            }
        }
    }

    public void exportUntrustedCertificate(String name, Path path, char[] password, ExportType type) throws IOException, GeneralSecurityException {
        SelfSignedX509CertificateAndSigningKey certificate = SelfSignedX509CertificateAndSigningKey.builder().setDn(this.dn(name)).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setKeyAlgorithmName(KEY_ALGORITHM).addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        KeyStore keyStore = CertificateAuthority.getKeyStore(type.providerName, type.type);
        Files.createDirectories(path, new FileAttribute[0]);
        keyStore.setKeyEntry(name, certificate.getSigningKey(), password, new X509Certificate[]{certificate.getSelfSignedCertificate()});
        try (OutputStream os = Files.newOutputStream(path.resolve(name + "." + type.ext()), new OpenOption[0]);){
            keyStore.store(os, password);
        }
    }

    public static boolean hasProvider(String providerName) {
        for (Provider p : ALL_PROVIDERS) {
            if (!p.getName().equals(providerName)) continue;
            return true;
        }
        return false;
    }

    private static KeyStore getKeyStore(String providerName, String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Provider provider = ProviderUtil.findProvider((Provider[])ALL_PROVIDERS, (String)providerName, KeyStore.class, (String)type);
        KeyStore keyStore = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        keyStore.load(null, null);
        return keyStore;
    }

    protected X500Principal dn(String cn) {
        return new X500Principal("cn=" + cn + "," + this.baseDN);
    }

    public static enum ExportType {
        PFX("pkcs12"),
        BCFKS("BC", "bcfks"),
        PEM("pem"),
        CRT("crt"),
        KEY("key");

        private final String providerName;
        private final String type;

        private ExportType(String type) {
            this(null, type);
        }

        private ExportType(String providerName, String type) {
            this.providerName = providerName;
            this.type = type;
        }

        public String ext() {
            return this.name().toLowerCase();
        }
    }
}

