/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import net.spy.memcached.ConnectionFactoryBuilder;
import org.infinispan.cli.user.UserTool;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.maven.Artifact;
import org.infinispan.commons.maven.MavenSettings;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.NetworkAddress;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.CertificateAuthority;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.testing.Exceptions;
import org.infinispan.testing.Testing;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.Assume;

public abstract class AbstractInfinispanServerDriver
implements InfinispanServerDriver {
    public static final String DEFAULT_CLUSTERED_INFINISPAN_CONFIG_FILE_NAME = "infinispan.xml";
    public static final String TEST_HOST_ADDRESS = "org.infinispan.test.host.address";
    public static final String JOIN_TIMEOUT = "jgroups.join_timeout";
    public static final String KEY_PASSWORD = "secret";
    public static final int JMX_PORT = 9999;
    protected final InfinispanServerTestConfiguration configuration;
    protected final InetAddress testHostAddress;
    protected File rootDir;
    protected File confDir;
    protected ComponentStatus status;
    protected String name;

    protected AbstractInfinispanServerDriver(InfinispanServerTestConfiguration configuration, InetAddress testHostAddress) {
        this.configuration = configuration;
        this.testHostAddress = testHostAddress;
        this.status = ComponentStatus.INSTANTIATED;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.status;
    }

    @Override
    public InfinispanServerTestConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public InetAddress getTestHostAddress() {
        return this.testHostAddress;
    }

    protected abstract void start(String var1, File var2);

    protected String debugJvmOption() {
        String nonLoopbackAddress;
        try {
            nonLoopbackAddress = NetworkAddress.nonLoopback((String)"").getAddress().getHostAddress();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not find a non-loopback address");
        }
        return String.format("-agentlib:jdwp=transport=dt_socket,server=n,address=%s:5005", nonLoopbackAddress);
    }

    protected abstract void stop();

    @Override
    public void prepare(String name) {
        this.name = name;
        if (this.configuration.getFeatures() != null) {
            Features features = new Features(this.getClass().getClassLoader());
            for (String feature : this.configuration.getFeatures()) {
                Assume.assumeTrue((String)String.format("%s is disabled", feature), (boolean)features.isAvailable(feature));
            }
        }
        String siteName = this.configuration.site() == null ? "" : this.configuration.site();
        String testDir = Testing.tmpDirectory((String[])new String[]{siteName + name});
        Util.recursiveFileRemove((String)testDir);
        this.rootDir = new File(testDir);
        this.confDir = new File(this.rootDir, "conf");
        if (!this.confDir.mkdirs()) {
            throw new RuntimeException("Failed to create server configuration directory " + String.valueOf(this.confDir));
        }
        if (!this.configuration.isDefaultFile()) {
            this.copyProvidedServerConfigurationFile();
        }
        this.createUserFile("default");
        this.createKeyStores(CertificateAuthority.ExportType.PFX);
        if (CertificateAuthority.hasProvider("BC")) {
            this.createKeyStores(CertificateAuthority.ExportType.BCFKS);
        }
    }

    @Override
    public void start(String name) {
        this.status = ComponentStatus.INITIALIZING;
        try {
            log.infof("Starting servers %s", (Object)name);
            this.start(name, this.rootDir);
            log.infof("Started servers %s", (Object)name);
            this.status = ComponentStatus.RUNNING;
        }
        catch (Throwable t) {
            log.errorf(t, "Unable to start server %s", (Object)name);
            this.status = ComponentStatus.FAILED;
            throw t;
        }
    }

    @Override
    public final void stop(String name) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            this.status = ComponentStatus.STOPPING;
            log.infof("Stopping servers %s", (Object)name);
            this.stop();
            log.infof("Stopped servers %s", (Object)name);
        }
        this.status = ComponentStatus.TERMINATED;
    }

    private void copyProvidedServerConfigurationFile() {
        this.copyResource(this.configuration.configurationFile(), this.confDir.toPath());
    }

    private void copyResource(String resource, Path dst) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File configFile = new File(resource);
        if (configFile.isAbsolute()) {
            Path source = Paths.get(configFile.getParentFile().getAbsolutePath(), new String[0]);
            Exceptions.unchecked(() -> Util.recursiveDirectoryCopy((Path)source, (Path)dst));
            return;
        }
        URL resourceUrl = classLoader.getResource(resource);
        if (resourceUrl == null) {
            throw new RuntimeException("Cannot find test file: " + resource);
        }
        Exceptions.unchecked(() -> {
            if (resourceUrl.getProtocol().equals("jar")) {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                String[] parts = resourceUrl.toString().split("!");
                URI jarUri = new URI(parts[0]);
                try (FileSystem fs = FileSystems.newFileSystem(jarUri, env);){
                    String configJarPath = new File(parts[1]).getParentFile().toString();
                    Path source = fs.getPath(configJarPath, new String[0]);
                    Util.recursiveDirectoryCopy((Path)source, (Path)dst);
                }
            } else {
                Path source = Paths.get(resourceUrl.toURI().resolve("."));
                Util.recursiveDirectoryCopy((Path)source, (Path)dst);
            }
        });
    }

    protected static File createServerHierarchy(File baseDir) {
        return AbstractInfinispanServerDriver.createServerHierarchy(baseDir, null);
    }

    protected static File createServerHierarchy(File baseDir, String name) {
        File rootDir = AbstractInfinispanServerDriver.serverRoot(baseDir, name);
        for (String dir : Arrays.asList("data", "log", "lib")) {
            File d = new File(rootDir, dir);
            if (d.exists() || d.mkdirs()) continue;
            throw new IllegalStateException("Unable to create directory " + String.valueOf(d));
        }
        return rootDir;
    }

    protected static File serverRoot(File baseDir, String name) {
        return name == null ? baseDir : new File(baseDir, name);
    }

    protected void createUserFile(String realm) {
        ArrayList<String> algorithms = new ArrayList<String>(UserTool.DEFAULT_ALGORITHMS);
        algorithms.add("digest-md5");
        UserTool userTool = new UserTool(this.rootDir.getAbsolutePath());
        for (AuthorizationPermission authorizationPermission : AuthorizationPermission.values()) {
            String name = authorizationPermission.name().toLowerCase();
            userTool.createUser(name + "_user", name, realm, UserTool.Encryption.DEFAULT, Collections.singletonList(name), algorithms);
        }
        for (TestUser testUser : TestUser.values()) {
            if (testUser == TestUser.ANONYMOUS) continue;
            userTool.createUser(testUser.getUser(), testUser.getPassword(), realm, UserTool.Encryption.DEFAULT, testUser.getRoles(), algorithms);
        }
    }

    protected void copyArtifactsToDataDir() {
        if (this.configuration.getDataFiles() == null) {
            return;
        }
        File dataDir = new File(this.rootDir, "data");
        dataDir.mkdirs();
        for (String file : this.configuration.getDataFiles()) {
            this.copyResource(file, dataDir.toPath());
        }
    }

    protected void copyArtifactsToUserLibDir(File libDir) {
        String propertyArtifacts = this.configuration.properties().getProperty("org.infinispan.test.server.extension.libs");
        if (propertyArtifacts != null) {
            this.addArtifactsToLibDir(libDir, propertyArtifacts.replaceAll("\\s+", "").split(","));
        }
        this.addArtifactsToLibDir(libDir, this.configuration.mavenArtifacts());
        if (this.configuration.archives() != null) {
            for (Archive<?> artifact : this.configuration.archives()) {
                File jar = libDir.toPath().resolve(artifact.getName()).toFile();
                jar.setWritable(true, false);
                ((ZipExporter)artifact.as(ZipExporter.class)).exportTo(jar, true);
                log.infof("Artifact: %s", (Object)jar);
            }
        }
    }

    protected void addArtifactsToLibDir(File libDir, String ... artifacts) {
        if (artifacts != null && artifacts.length > 0) {
            MavenSettings.init();
            for (String artifact : artifacts) {
                Artifact a = Artifact.fromString((String)artifact);
                log.infof("Artifact: %s", (Object)a);
                try {
                    Path resolved = a.resolveArtifact();
                    Files.copy(resolved, libDir.toPath().resolve(resolved.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public File getCertificateFile(String name) {
        return new File(this.confDir, name);
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public File getConfDir() {
        return this.confDir;
    }

    public String getName() {
        return this.name;
    }

    protected void createKeyStores(CertificateAuthority.ExportType type) {
        try {
            CertificateAuthority certificateAuthority = this.configuration.certificateAuthority();
            certificateAuthority.exportCertificates(this.confDir.toPath().resolve("ca." + type.ext()), type, KEY_PASSWORD.toCharArray(), "ca");
            certificateAuthority.getCertificate("server", this.testHostAddress);
            certificateAuthority.exportCertificateWithKey("server", this.confDir.toPath(), KEY_PASSWORD.toCharArray(), type);
            for (TestUser user : TestUser.values()) {
                if (user == TestUser.ANONYMOUS) continue;
                certificateAuthority.exportCertificateWithKey(user.getUser(), this.confDir.toPath(), KEY_PASSWORD.toCharArray(), type);
            }
            certificateAuthority.exportCertificateWithKey("supervisor", this.confDir.toPath(), KEY_PASSWORD.toCharArray(), type);
            certificateAuthority.exportCertificates(this.confDir.toPath().resolve("trust." + type.ext()), type, KEY_PASSWORD.toCharArray(), new String[0]);
            certificateAuthority.exportUntrustedCertificate("untrusted", this.confDir.toPath(), KEY_PASSWORD.toCharArray(), type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName) {
        this.applyKeyStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray()).keyStoreType(type).provider(provider);
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName) {
        this.applyKeyStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray()).keyStoreType(type).provider(provider);
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName) {
        this.applyTrustStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray()).trustStoreType(type).provider(provider);
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName) {
        this.applyTrustStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray()).trustStoreType(type).provider(provider);
    }

    @Override
    public void applyTrustStore(ConnectionFactoryBuilder builder, String certificateName) {
        this.applyTrustStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyTrustStore(ConnectionFactoryBuilder builder, String certificateName, String type, String provider) {
        SslContextFactory factory = new SslContextFactory();
        SSLContext context = factory.trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray()).trustStoreType(type).provider(provider).build().sslContext();
        builder.setSSLContext(context).setSkipTlsHostnameVerification(true);
    }

    @Override
    public void pause(int server) {
    }

    @Override
    public RemoteCacheManager createRemoteCacheManager(ConfigurationBuilder builder) {
        return new RemoteCacheManager(builder.build());
    }

    public static String abbreviate(String name) {
        String[] split = name.split("[./-]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            if (split[i].isBlank()) continue;
            sb.append(split[i].charAt(0));
            sb.append('.');
        }
        sb.append(split[split.length - 1]);
        return sb.toString();
    }
}

