/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import org.infinispan.server.test.api.AbstractTestClientDriver;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class MemcachedTestClientDriver
extends AbstractTestClientDriver<MemcachedTestClientDriver> {
    private final TestServer testServer;
    private final TestClient testClient;
    private ConnectionFactoryBuilder builder;
    private int port = 11222;

    public MemcachedTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
        this.applyDefaultConfiguration(builder);
        this.builder = builder;
    }

    public MemcachedTestClientDriver withClientConfiguration(ConnectionFactoryBuilder builder) {
        this.builder = this.applyDefaultConfiguration(builder);
        return this;
    }

    public MemcachedTestClientDriver withPort(int port) {
        this.port = port;
        return this;
    }

    public MemcachedClient get() {
        return this.testClient.registerResource(this.testServer.newMemcachedClient(this.builder, this.port)).client();
    }

    public MemcachedTestClientDriver self() {
        return this;
    }

    private ConnectionFactoryBuilder applyDefaultConfiguration(ConnectionFactoryBuilder builder) {
        if (this.testServer.isContainerRunWithDefaultServerConfig()) {
            builder.setAuthDescriptor(AuthDescriptor.typical((String)TestUser.ADMIN.getUser(), (String)TestUser.ADMIN.getPassword()));
        }
        builder.setClientMode(ClientMode.Static);
        return builder;
    }
}

