/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unzip {
    public static List<Path> unzip(Path zip, Path directory) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        Files.createDirectories(directory, new FileAttribute[0]);
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Path file = directory.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                } else {
                    try (OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);){
                        int read;
                        byte[] bytesIn = new byte[4096];
                        while ((read = zipIn.read(bytesIn)) != -1) {
                            fos.write(bytesIn, 0, read);
                        }
                    }
                    files.add(file);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return files;
    }
}

