/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import java.io.Closeable;
import java.net.InetSocketAddress;
import org.infinispan.server.test.api.AbstractTestClientDriver;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class RespTestClientDriver
extends AbstractTestClientDriver<RespTestClientDriver> {
    private final TestServer testServer;
    private final TestClient testClient;
    private Vertx vertx;
    private RedisOptions options;
    private boolean requireSsl;
    private int port = 11222;

    public RespTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
    }

    public RespTestClientDriver withPort(int port) {
        this.port = port;
        return this;
    }

    public RespTestClientDriver self() {
        return this;
    }

    public RespTestClientDriver withOptions(RedisOptions options) {
        if (!"redis://localhost:6379".equals(options.getEndpoint())) {
            throw new IllegalStateException("Endpoints should not be configured!");
        }
        this.options = options;
        return this;
    }

    public RespTestClientDriver requireSsl(boolean requireSsl) {
        this.requireSsl = requireSsl;
        return this;
    }

    public RespTestClientDriver withVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public Redis get() {
        RespVertxClient client = new RespVertxClient(this.applyDefaultOptions(), this.vertx);
        this.testClient.registerResource(client);
        return client.get();
    }

    public Redis get(int index) {
        RespVertxClient client = new RespVertxClient(this.specificServerOptions(index), this.vertx);
        this.testClient.registerResource(client);
        return client.get();
    }

    public String connectionString() {
        return String.join((CharSequence)"", this.applyDefaultOptions().getEndpoints());
    }

    public String connectionString(int index) {
        return this.specificServerOptions(index).getEndpoint();
    }

    public RedisConnection connect(Redis client) {
        RedisConnection conn = (RedisConnection)client.connect().result();
        this.testClient.registerResource(() -> ((RedisConnection)conn).close());
        return conn;
    }

    private RedisOptions applyUrl(RedisOptions redisOptions, InetSocketAddress serverSocket) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.requireSsl ? "rediss://" : "redis://");
        if (this.user != null && this.user != TestUser.ANONYMOUS) {
            sb.append(this.user.getUser()).append(":").append(this.user.getPassword()).append("@");
        } else if (this.userPerm != null) {
            sb.append(this.userPerm.name().toLowerCase()).append("_user").append(":").append(this.userPerm.name().toLowerCase()).append("@");
        }
        sb.append(serverSocket.getHostString()).append(":").append(serverSocket.getPort());
        if (this.requireSsl) {
            sb.append("?verifyPeer=NONE");
        }
        return redisOptions.addConnectionString(sb.toString());
    }

    protected RedisOptions applyDefaultOptions() {
        int size = this.testServer.getDriver().getConfiguration().numServers();
        RedisOptions opts = (this.options != null ? this.options : new RedisOptions()).setPoolName("resp-tests-pool");
        opts = size > 1 ? opts.setType(RedisClientType.CLUSTER) : opts.setType(RedisClientType.STANDALONE);
        for (int i = 0; i < size; ++i) {
            opts = this.applyUrl(opts, this.testServer.getDriver().getServerSocket(i, this.port));
        }
        return opts;
    }

    protected RedisOptions specificServerOptions(int index) {
        InetSocketAddress serverSocket = this.testServer.getDriver().getServerSocket(index, this.port);
        RedisOptions redisOptions = new RedisOptions().setType(RedisClientType.STANDALONE).setMaxPoolWaiting(-1).setPoolName("resp-index-" + index);
        redisOptions = this.applyUrl(redisOptions, serverSocket);
        return redisOptions;
    }

    public RedisConnection getConnection() {
        return this.connect(this.get());
    }

    private static class RespVertxClient
    extends AbstractVerticle
    implements Closeable {
        private final RedisOptions options;
        private Redis client;

        private RespVertxClient(RedisOptions options, Vertx vertx) {
            this.options = options;
            this.vertx = vertx;
        }

        private Redis get() {
            assert (this.client == null) : "Vertx Redis client already created";
            this.client = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.options);
            return this.client;
        }

        @Override
        public void close() {
            if (this.client != null) {
                this.client.close();
            }
        }
    }
}

