/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.rollingupgrade;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeHandler;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RollingUpgradeXSiteHandler {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Map<String, RollingUpgradeHandler> sites;

    private RollingUpgradeXSiteHandler(Map<String, RollingUpgradeHandler> sites) {
        this.sites = sites;
    }

    public static RollingUpgradeXSiteHandler startOldClusters(Map<String, RollingUpgradeConfiguration> sites) {
        HashMap<String, RollingUpgradeHandler> siteHandlers = new HashMap<String, RollingUpgradeHandler>(sites.size());
        for (Map.Entry<String, RollingUpgradeConfiguration> site : sites.entrySet()) {
            siteHandlers.put(site.getKey(), RollingUpgradeHandler.startOldCluster(site.getValue(), site.getKey()));
        }
        return new RollingUpgradeXSiteHandler(siteHandlers);
    }

    public RollingUpgradeHandler handlerForSite(String siteName) {
        return this.sites.get(siteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeUpgrade(boolean shouldClose) {
        Throwable throwableEncountered = null;
        try {
            for (Map.Entry<String, RollingUpgradeHandler> entry : this.sites.entrySet()) {
                String siteName = entry.getKey();
                RollingUpgradeHandler ruh = entry.getValue();
                try {
                    ruh.completeUpgrade(false);
                }
                catch (Throwable t) {
                    log.errorf(t, "Exception encountered with site %s", (Object)siteName);
                    ruh.exceptionEncountered(t);
                    if (throwableEncountered != null) continue;
                    throwableEncountered = t;
                }
            }
            if (throwableEncountered != null) {
                throw Util.unchecked(throwableEncountered);
            }
        }
        finally {
            if (shouldClose) {
                this.close();
            }
        }
    }

    public void close() {
        this.sites.forEach((siteName, ruh) -> ruh.close());
    }

    public void exceptionEncountered(Throwable throwable) {
        this.sites.forEach((siteName, ruh) -> ruh.exceptionEncountered(throwable));
    }
}

